package cayte.frame.task;

import java.util.Observable;

public class TaskManager extends Observable {

    public static final int CANCEL_ALL = 0;

    public void cancelAll() {
        setChanged();
        notifyObservers(CANCEL_ALL);
        super.deleteObservers();
    }

    /**
     * 执行线程并加入到TaskManager中
     *
     * @param genericTask GenericTask
     * @param <Params>    参数泛型
     */
    public <Params> void execute(GenericTask<Params> genericTask) {
        if (genericTask.getStatus() != android.os.AsyncTask.Status.PENDING)
            return;
        genericTask.execute();
        super.addObserver(genericTask);
    }

    /**
     * 执行线程并加入到TaskManager中
     *
     * @param genericTask GenericTask
     * @param params      参数集合
     * @param <Params>    参数泛型
     */
    public <Params> void execute(GenericTask<Params> genericTask, Params... params) {
        if (genericTask.getStatus() != android.os.AsyncTask.Status.PENDING)
            return;
        genericTask.execute(params);
        super.addObserver(genericTask);
    }

}