package cayte.frame.task;

public abstract class TaskAdapter implements TaskListener {

	private boolean isRun = false;

	@Override
	public boolean isRun() {
		return isRun;
	}

	@Override
	public void onPreExecute() {
		isRun = true;
	}

	@Override
	public void onPostExecute(TaskResult result) {
		isRun = false;
	}

	@Override
	public void onProgressUpdate(TaskProgress... param) {

	}

	@Override
	public void onCancelled() {
		isRun = false;
	}

}
