package cayte.frame.task;

import java.util.Observable;
import java.util.Observer;

public abstract class GenericThread<T> extends Thread implements Observer {

	protected TaskListener mListener = null;
	protected boolean isCancelable = false;

	protected T[] params = null;

	public GenericThread(T... params) {
		this.params = params;
	}

	protected abstract TaskResult _doInBackground(T... params);

	public void setListener(TaskListener taskListener) {
		mListener = taskListener;
	}

	public TaskListener getListener() {
		return mListener;
	}

	protected void onCancelled() {
		try {
			if (mListener != null)
				mListener.onCancelled();
		} catch (Exception e) {
		}
	}

	protected void onPreExecute() {
		try {
			if (mListener != null)
				mListener.onPreExecute();
		} catch (Exception e) {
		}
	}

	@Override
	public synchronized void start() {
		onPreExecute();
		super.start();
	}

	@Override
	public void run() {
		TaskResult result = _doInBackground(params);
		if (isCancelable && isInterrupted()) {
			onCancelled();
		} else {
			onPostExecute(result);
		}
	}

	public void publishProgress(final TaskProgress... values) {
		onProgressUpdate(values);
	}

	protected void onProgressUpdate(TaskProgress... values) {
		try {
			if (mListener != null) {
				if (values != null && values.length > 0) {
					mListener.onProgressUpdate(values);
				}
			}
		} catch (Exception e) {
		}
	}

	protected void onPostExecute(TaskResult result) {
		try {
			if (mListener != null)
				mListener.onPostExecute(result);
		} catch (Exception e) {
		}
	}

	public void cancel() {
		isCancelable = true;
		if (!isInterrupted())
			interrupt();
	}

	@Override
	public void update(Observable o, Object arg) {
		if (TaskManager.CANCEL_ALL == (Integer) arg && !isCancelable) {
			cancel();
		}
	}

}
