package cayte.frame.task;

import android.os.AsyncTask;

import java.util.Observable;
import java.util.Observer;

public abstract class GenericTask<Params> extends AsyncTask<Params, TaskProgress, TaskResult> implements Observer {

    protected TaskListener mListener = null;
    protected boolean isCancelable = false;

    protected abstract TaskResult _doInBackground(Params... params);

    public TaskListener getListener() {
        return mListener;
    }

    public void setListener(TaskListener taskListener) {
        mListener = taskListener;
    }

    @Override
    protected void onCancelled() {
        isCancelable = true;
        super.onCancelled();
        try {
            if (mListener != null)
                mListener.onCancelled();
        } catch (Exception e) {
        }
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        try {
            if (mListener != null)
                mListener.onPreExecute();
        } catch (Exception e) {
        }
    }

    @Override
    protected TaskResult doInBackground(Params... params) {
        TaskResult result = _doInBackground(params);
        return result;
    }

    @Override
    protected void onProgressUpdate(TaskProgress... values) {
        super.onProgressUpdate(values);
        try {
            if (mListener != null) {
                if (values != null && values.length > 0) {
                    mListener.onProgressUpdate(values);
                }
            }
        } catch (Exception e) {
        }
    }

    @Override
    protected void onPostExecute(TaskResult result) {
        super.onPostExecute(result);
        try {
            if (mListener != null)
                mListener.onPostExecute(result);
        } catch (Exception e) {
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (TaskManager.CANCEL_ALL == (int) arg && !isCancelable) {
            isCancelable = true;
            if (getStatus() == Status.RUNNING) {
                cancel(true);
            }
        }
    }

}
