package cayte.frame.manager;

import android.graphics.Typeface;
import android.text.Html;
import android.widget.TextView;

public class TypefaceManager {
	private static TypefaceManager instance;

	private TypefaceManager() {
	}

	public static TypefaceManager instance() {
		if (instance == null) {
			synchronized (TypefaceManager.class) {
				if (instance == null)
					instance = new TypefaceManager();
			}
		}
		return instance;
	}

	public void setBoldTextView(TextView... textView) {
		for (TextView tv : textView) {
			if (tv == null)
				continue;
			tv.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
			tv.getPaint().setFakeBoldText(true);
		}
	}

	public CharSequence setBoldText4Html(String text, String rgb) {
		String html = "<font color='#" + rgb + "'><tt><b>" + text + "</b></tt></font>";
		return Html.fromHtml(html);
	}

}
