package cayte.frame.log;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;

public class D {

	public static final String TAG = "cayte";

	private static Context context = null;

	public static boolean IS_LOG = true; // 日志总开关
	public static boolean IS_LOG_FILE = false; // 日志总开关

	public static void init(Context context) {
		IS_LOG = true;
		D.context = context.getApplicationContext();
	}

	public static void d(String msg) {
		if (!IS_LOG)
			return;
		Log.d(TAG, msg);
		if (IS_LOG_FILE)
			L.log("debug", TAG, msg);
	}

	public static void d(String TAG, String msg) {
		if (!IS_LOG)
			return;
		Log.d(TAG, msg);
		if (IS_LOG_FILE)
			L.log("debug", TAG, msg);
	}

	public static void i(String msg) {
		if (!IS_LOG)
			return;
		Log.i(TAG, msg);
		if (IS_LOG_FILE)
			L.log("info", TAG, msg);
	}

	public static void i(String TAG, String msg) {
		if (!IS_LOG)
			return;
		Log.i(TAG, msg);
		if (IS_LOG_FILE)
			L.log("info", TAG, msg);
	}

	public static void v(String msg) {
		if (!IS_LOG)
			return;
		Log.v(TAG, msg);
		if (IS_LOG_FILE)
			L.log("verbose", TAG, msg);
	}

	public static void v(String TAG, String msg) {
		if (!IS_LOG)
			return;
		Log.v(TAG, msg);
		if (IS_LOG_FILE)
			L.log("verbose", TAG, msg);
	}

	public static void w(String msg) {
		if (!IS_LOG)
			return;
		Log.w(TAG, msg);
		if (IS_LOG_FILE)
			L.log("warn", TAG, msg);
	}

	public static void w(String TAG, String msg) {
		if (!IS_LOG)
			return;
		Log.w(TAG, msg);
		if (IS_LOG_FILE)
			L.log("warn", TAG, msg);
	}

	public static void w(String msg, Throwable tr) {
		if (!IS_LOG)
			return;
		Log.w(TAG, msg, tr);
		if (IS_LOG_FILE)
			L.log("warn", TAG, msg, tr);
	}

	public static void w(String TAG, String msg, Throwable tr) {
		if (!IS_LOG)
			return;
		Log.w(TAG, msg, tr);
		if (IS_LOG_FILE)
			L.log("warn", TAG, msg, tr);
	}

	public static void e(String msg) {
		if (!IS_LOG)
			return;
		Log.e(TAG, msg);
		if (IS_LOG_FILE)
			L.log("error", TAG, msg);
	}

	public static void e(String TAG, String msg) {
		if (!IS_LOG)
			return;
		Log.e(TAG, msg);
		if (IS_LOG_FILE)
			L.log("error", TAG, msg);
	}

	public static void e(String msg, Throwable tr) {
		if (!IS_LOG)
			return;
		Log.e(TAG, msg, tr);
		if (IS_LOG_FILE)
			L.log("error", TAG, msg, tr);
	}

	public static void e(String TAG, String msg, Throwable tr) {
		if (!IS_LOG)
			return;
		Log.e(TAG, msg, tr);
		if (IS_LOG_FILE)
			L.log("error", TAG, msg, tr);
	}

	public static void toast(CharSequence text) {
		if (context != null)
			Toast.makeText(context, text, Toast.LENGTH_SHORT).show();
	}

	public static void toast(int text) {
		if (context != null)
			Toast.makeText(context, text, Toast.LENGTH_SHORT).show();
	}

	/**
	 * sleep thread
	 * 
	 * @param time
	 *            time
	 */
	public static void sleep(long time) {
		if (time <= 0)
			return;
		try {
			Thread.sleep(time);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

}
