package cayte.frame.helper;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

/**
 * 
 * get mobile net information
 * 
 */
public class NetworkHelper {

	private Context mCon;
	private static NetworkHelper instance;

	public NetworkHelper(Context mCon) {
		this.mCon = mCon.getApplicationContext();
	}

	public static NetworkHelper instance(Context mCon) {
		if (instance == null) {
			synchronized (NetworkHelper.class) {
				if (instance == null)
					instance = new NetworkHelper(mCon);
			}
		}
		return instance;
	}

	public boolean isConnected() {
		ConnectivityManager mConManager = (ConnectivityManager) mCon
				.getSystemService(Context.CONNECTIVITY_SERVICE);
		if (mConManager != null) {
			NetworkInfo info = mConManager.getActiveNetworkInfo();
			if (info != null && info.isConnected()) {
				if (info.getState() == NetworkInfo.State.CONNECTED) {
					return true;
				}
			}
		}
		return false;
	}

	public boolean isNetSucces() {
		ConnectivityManager cwjManager = (ConnectivityManager) mCon
				.getSystemService(Context.CONNECTIVITY_SERVICE);
		NetworkInfo info = cwjManager.getActiveNetworkInfo();
		if (info != null && info.isAvailable()) {
			return true;
		} else {
			return false;
		}
	}
}
