package cayte.frame.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.Thread.UncaughtExceptionHandler;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

@SuppressLint("SimpleDateFormat")
public class ApplicationCrashHelper implements UncaughtExceptionHandler {

    private OnUncaughtException onUncaught = null;

    public abstract interface OnUncaughtException {
        public void onUncaughtException(String... texts);
    }

    private static ApplicationCrashHelper instance;

    private ApplicationCrashHelper() {

    }

    public static ApplicationCrashHelper instance() {
        if (instance == null) {
            synchronized (ApplicationCrashHelper.class) {
                if (instance == null)
                    instance = new ApplicationCrashHelper();
            }
        }
        return instance;
    }

    private Context context;
    private DateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void init(Context context, OnUncaughtException onUncaught) {
        this.context = context.getApplicationContext();
        this.onUncaught = onUncaught;
    }

    public void uncaughtException(Thread arg0, Throwable arg1) {
        // 1.获取当前程序的版本号. 版本的id
        String versioninfo = getVersionInfo();

        // 2.获取手机的硬件信息.
        String mobileInfo = getMobileInfo();

        // 3.把错误的堆栈信息 获取出来
        String errorinfo = getErrorInfo(arg1);

        // 4.把所有的信息 还有信息对应的时间 提交到服务器
        try {
            if (onUncaught != null)
                onUncaught.onUncaughtException(dataFormat.format(new Date()), versioninfo, mobileInfo, errorinfo);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private String getErrorInfo(Throwable arg1) {
        Writer writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        arg1.printStackTrace(pw);
        pw.close();
        String error = writer.toString();
        return error;
    }

    private String getMobileInfo() {
        StringBuffer sb = new StringBuffer();
        // 通过反射获取系统的硬件信息
        try {
            Field[] fields = Build.class.getDeclaredFields();
            for (Field field : fields) {
                // 暴力反射 ,获取私有的信息
                field.setAccessible(true);
                String name = field.getName();
                String value = field.get(null).toString();
                sb.append(name + "=" + value);
                sb.append("\n");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private String getVersionInfo() {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(context.getPackageName(), 0);
            return "versionCode : " + info.versionCode + "   versionName : " + info.versionName;
        } catch (Exception e) {
            e.printStackTrace();
            return "Version unknown!";
        }
    }
}
