package cayte.frame.file;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.MediaStore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

/**
 * 文件操作helper类
 *
 * @author Cayte
 */
public class FileUtils {

    public static boolean saveBitmap(File file, Bitmap bitmap, int quality) {
        OutputStream os = null;
        try {
            if (file.exists())
                file.delete();
            os = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, os);
            os.close();
            return true;
        } catch (Exception e) {
            return false;
        } finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            } catch (IOException e) {
            }
        }
    }

    public static boolean saveAlbum(Context con, File file) {
        try {
            MediaStore.Images.Media.insertImage(con.getContentResolver(), file.getAbsolutePath(), file.getName(), null);
            con.sendBroadcast(new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, Uri.fromFile(file)));
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public static boolean fileChannelCopy(File f, File t) {
        FileInputStream fi = null;
        FileOutputStream fo = null;
        FileChannel in = null;
        FileChannel out = null;
        try {
            fi = new FileInputStream(f);
            fo = new FileOutputStream(t);
            in = fi.getChannel();
            out = fo.getChannel();
            in.transferTo(0, in.size(), out);
            return true;
        } catch (Exception e) {
            return false;
        } finally {
            try {
                if (fi != null)
                    fi.close();
                if (in != null)
                    in.close();
                if (fo != null)
                    fo.close();
                if (out != null)
                    out.close();
            } catch (IOException e) {
            }
        }
    }

    public static boolean rename(String oldPath, String newPath) {
        try {
            File mSourceFile = new File(oldPath);
            File ff = new File(newPath);
            if (ff.exists())
                ff.delete();
            mSourceFile.renameTo(ff);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

}
