package cayte.frame.file;

import android.os.Environment;

import java.io.File;

import cayte.frame.init.C;

public class F {

    private static final String FILE = "file";
    private static final String CACHE = "cache";

    public static String customDirName = C.context.getPackageName();
    private static String userDirName = null;
    private static M defaultMode = M.app;

    public static void defaultMode(M mode) {
        F.defaultMode = mode;
    }

    public static void customDirName(String customDirName) {
        F.customDirName = customDirName;
    }

    public static boolean isSDExist() {
        if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState()))
            return true;
        return false;
    }

    public static String getSDPath() {
        return Environment.getExternalStorageDirectory().getPath() + File.separator;
    }

    public static String getFilePath4app() {
        return C.context.getFilesDir().getPath() + File.separator;
    }

    public static String getFilePath4SDAndroid() {
        if (isSDExist())
            return getSDPath() + "Android" + File.separator + "data" + File.separator + C.context.getPackageName() + File.separator + FILE + File.separator;
        else
            return getFilePath4app();
    }

    public static String getFilePath4SDCustom() {
        if (isSDExist())
            return getSDPath() + F.customDirName + File.separator + FILE + File.separator;
        else
            return getFilePath4app();
    }

    public static String getCachePath4app() {
        return C.context.getCacheDir().getPath() + File.separator;
    }

    public static String getCachePath4SDAndroid() {
        if (isSDExist())
            return getSDPath() + "Android" + File.separator + "data" + File.separator + C.context.getPackageName() + File.separator + CACHE + File.separator;
        else
            return getCachePath4app();
    }

    public static String getCachePath4SDCustom() {
        if (isSDExist())
            return getSDPath() + F.customDirName + File.separator + CACHE + File.separator;
        else
            return getCachePath4app();
    }

    public static String getFilePath() {
        return getFilePath(defaultMode);
    }

    public static String getFilePath(M mode) {
        String root = null;
        switch (mode) {
            case app:
            default:
                root = getFilePath4app();
                break;
            case SDAndroid:
                root = getFilePath4SDAndroid();
                break;
            case SDCustom:
                root = getFilePath4SDCustom();
                break;
        }
        if (checkFolder(root)) {
            return root;
        } else {
            defaultMode = M.app;
            root = getFilePath4app();
            return root;
        }
    }

    public static String getCachePath() {
        return getCachePath(defaultMode);
    }

    public static String getCachePath(M mode) {
        String root = null;
        switch (mode) {
            case app:
            default:
                root = getCachePath4app();
                break;
            case SDAndroid:
                root = getCachePath4SDAndroid();
                break;
            case SDCustom:
                root = getCachePath4SDCustom();
                break;
        }
        if (checkFolder(root)) {
            return root;
        } else {
            defaultMode = M.app;
            root = getCachePath4app();
            return root;
        }
    }

    public static String getFile(String mark) {
        return getFile(defaultMode, mark);
    }

    public static String getFile(M mode, String mark) {
        String path = getFilePath(mode) + mark + File.separator;
        checkFolder(path);
        return path;
    }

    public static String getCache(String mark) {
        return getCache(defaultMode, mark);
    }

    public static String getCache(M mode, String mark) {
        String path = getCachePath(mode) + mark + File.separator;
        checkFolder(path);
        return path;
    }


    public static void loginUser(String id) {
        F.userDirName = "USER_" + id;
    }

    public static void logoutUser() {
        F.userDirName = null;
    }


    public static String getUserFile() {
        if (userDirName == null)
            return null;
        return getFile(userDirName);
    }

    public static String getUserCache() {
        if (userDirName == null)
            return null;
        return getCache(userDirName);
    }

    public static boolean checkFolder(String path) {
        return FolderUtils.checkFolder(path);
    }

    public static void deleteFile(String path) {
        FolderUtils.deleteFile(path);
    }

    public static void deleteFile(File file) {
        FolderUtils.deleteFile(file.getPath());
    }

    public static void clearCache() {
        deleteFile(getCachePath());
    }

    public static enum M {
        app, SDAndroid, SDCustom;
    }

}
