package cayte.frame.dialog;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import android.app.Dialog;
import android.content.DialogInterface;
import android.content.DialogInterface.OnDismissListener;
import android.view.View;

public class BaseDialogHelper {
	protected Map<String, Dialog> ads;

	public BaseDialogHelper() {
		ads = new HashMap<String, Dialog>();
	}

	private void addDialog(final String key, Dialog d, final DialogListener l) {
		d.setOnDismissListener(new OnDismissListener() {

			@Override
			public void onDismiss(DialogInterface dialog) {
				ads.remove(key);
				if (l != null)
					l.onDismiss();
			}
		});
		ads.put(key, d);
	}

	protected void showDialog(String key, Dialog d) {
		showDialog(key, d, null);
	}

	protected void showDialog(String key, Dialog d, DialogListener l) {
		addDialog(key, d, l);
		d.show();
	}

	protected void dismissDialog(String key) {
		if (ads.containsKey(key)) {
			Dialog dialog = ads.remove(key);
			if (dialog != null)
				dialog.dismiss();
		}
	}

	protected boolean checkDialog(String key) {
		if (!ads.containsKey(key))
			return true;
		else {
			if (ads.get(key) == null) {
				ads.remove(key);
				return true;
			} else {
				if (!ads.get(key).isShowing()) {
					ads.remove(key);
					return true;
				}
			}
		}
		return false;
	}

	protected View findDialogView(String key, int id) {
		if (ads.containsKey(key)) {
			Dialog dialog = ads.get(key);
			if (dialog != null && dialog.isShowing())
				return dialog.findViewById(id);
		}
		return null;
	}

	public void clear() {
		Set<String> keys = ads.keySet();
		for (String key : keys) {
			Dialog dialog = ads.remove(key);
			if (dialog != null)
				dialog.dismiss();
		}
	}

}
