package cayte.frame.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.View;

/**
 * Created by cayte on 2016/10/31.
 */

public abstract class RecycleViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener, View.OnLongClickListener {

    public int postion = -1;
    protected OnItemClick onItemClick;
    protected OnItemLongClick onItemLongClick;

    public RecycleViewHolder(View itemView) {
        super(itemView);
        initView(postion, itemView);
        itemView.setOnClickListener(this);
        itemView.setOnLongClickListener(this);
    }

    public void setPostion(int postion) {
        this.postion = postion;
    }

    protected abstract void initView(int postion, View itemView);

    public void setOnItemClick(OnItemClick onItemClick) {
        this.onItemClick = onItemClick;
    }

    public void setOnItemLongClick(OnItemLongClick onItemLongClick) {
        this.onItemLongClick = onItemLongClick;
    }

    @Override
    public void onClick(View v) {
        if (postion >= 0 && onItemClick != null)
            onItemClick._onClick(itemView, postion);
    }

    @Override
    public boolean onLongClick(View v) {
        if (postion >= 0 && onItemLongClick != null)
            return onItemLongClick._onLongClick(itemView, postion);
        return false;
    }
}
