package cayte.frame.act;

import java.io.Serializable;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import cayte.frame.data.BaseObject;

public class Screen {

	private Context from;
	private Class<?> to;
	private String action;
	private String packageName;

	private Intent intent = null;

	public static Screen create() {
		return new Screen();
	}

	public Screen() {
	}

	public Screen from(Context con) {
		this.from = con;
		return this;
	}

	public Screen to(Class<?> cls) {
		this.to = cls;
		return this;
	}

	public Screen action(String action) {
		this.action = action;
		return this;
	}

	public Screen intent(Intent intent) {
		this.intent = intent;
		return this;
	}

	public Intent getIntent() {
		if (intent == null) {
			if (from != null && to != null)
				intent = new Intent(from, to);
			else {
				if (action != null) {
					if (intent == null)
						intent = new Intent(action);
					else
						intent.setAction(action);
				}
			}
			if (packageName != null)
				intent.setPackage(packageName);
		}
		return intent;
	}

	public Screen setPackageName(String packageName) {
		this.packageName = packageName;
		return this;
	}

	public Screen putExtra(String name, CharSequence value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen putExtra(String name, String value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen putExtra(String name, int value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen putExtra(String name, boolean value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen putExtra(String name, double value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen putExtra(String name, float value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen putExtra(String name, short value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen putExtra(String name, long value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen putExtra(String name, Parcelable value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen putExtra(String name, Serializable value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen putExtra(String name, Bundle value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen putBean(BaseObject value) {
		return putBean("bean", value);
	}

	public Screen putBean(String name, BaseObject value) {
		getIntent().putExtra(name, value);
		return this;
	}

	public Screen addFlag(int flags) {
		getIntent().addFlags(flags);
		return this;
	}

	public Screen setFlag(int flags) {
		getIntent().setFlags(flags);
		return this;
	}

	public Screen setData(Uri data) {
		getIntent().setData(data);
		return this;
	}

	public Screen setDataAndType(Uri data, String type) {
		getIntent().setDataAndType(data, type);
		return this;
	}

	public void start() {
		from.startActivity(getIntent());
	}

	public void startService() {
		from.startService(getIntent());
	}

	public void startForResult(int requestCode) {
		if (from instanceof Activity)
			((Activity) from).startActivityForResult(getIntent(), requestCode);
	}

}
