package cayte.frame.act;

import android.app.Activity;

import java.util.Stack;

import cayte.frame.log.D;

public class ActivityStack {
    private static final String TAG = ActivityStack.class.getCanonicalName();

    private static Stack<Activity> activityStack;

    private static ActivityStack instance;

    private ActivityStack() {
        activityStack = new Stack<Activity>();
    }

    public static ActivityStack instance() {
        if (instance == null) {
            synchronized (ActivityStack.class) {
                if (instance == null)
                    instance = new ActivityStack();
            }
        }
        return instance;
    }

    public void popActivity() {
        Activity activity = activityStack.pop();
        D.d(TAG, "pop activity-->" + activity.getClass().getCanonicalName());
        if (activity != null) {
            activity.finish();
            activity = null;
        }
    }

    public void popActivity(Activity activity) {
        D.d(TAG, "pop activity-->" + activity.getClass().getCanonicalName());
        if (activity != null) {
            if (equalsActivity(activity, currentActivity())) {
                activity.finish();
                activityStack.pop();
                activity = null;
            }
        }
    }

    public void popToActivity(Class<?> cls) {
        Activity activity = null;
        while (true) {
            activity = currentActivity();
            if (activity == null) {
                break;
            }
            if (activity.getClass().equals(cls)) {
                break;
            }
            popActivity();
        }
    }

    public String currentActivityName() {
        if (activityStack.isEmpty())
            return "";
        Activity activity = activityStack.lastElement();
        String currentName = activity.getClass().getCanonicalName();
        activity = null;
        //        D.d("current activity-->" + currentName);
        return currentName;
    }

    public Activity currentActivity() {
        if (activityStack.isEmpty())
            return null;
        Activity activity = activityStack.lastElement();
        //        D.d("current activity-->" + activity.getClass().getCanonicalName());
        return activity;
    }

    public void pushActivity(Activity activity, int flag) {
        String actName = activity.getClass().getCanonicalName();
        D.d(TAG, "push activity-->" + actName);
        switch (flag) {
            case 0:
            default:
                break;
            case 1:
                if (Contains(actName)) {
                    Activity act = null;
                    while (true) {
                        act = activityStack.pop();
                        String str = act.getClass().getCanonicalName();
                        act.finish();
                        act = null;
                        if (actName.equals(str))
                            break;
                    }
                }
                break;
            case 2:
                Activity act = null;
                while (true) {
                    act = activityStack.pop();
                    act.finish();
                    act = null;
                    if (activityStack.size() == 1)
                        break;
                }
                break;
        }
        activityStack.add(activity);
    }

    public void popAllActivity() {
        D.d(TAG, "---pop all activity---");
        while (true) {
            if (currentActivity() == null) {
                break;
            }
            popActivity();
        }
    }

    public void popToTop() {
        D.d(TAG, "---pop to top activity---");
        while (true) {
            if (activityStack.size() <= 1) {
                break;
            }
            popActivity();
        }
    }

    public boolean Contains(Activity activity) {
        String actName = activity.getClass().getCanonicalName();
        return Contains(actName);
    }

    public boolean Contains(String actName) {
        for (Activity act : activityStack) {
            if (actName.equalsIgnoreCase(act.getClass().getCanonicalName()))
                return true;
        }
        return false;
    }

    public boolean equalsActivity(Activity act1, Activity act2) {
        if (act1 == null || act2 == null)
            return false;
        return act1.getClass().getCanonicalName().equalsIgnoreCase(act2.getClass().getCanonicalName());
    }

    public boolean equalsActivity(Activity act1, String act2) {
        if (act1 == null)
            return false;
        return act1.getClass().getCanonicalName().equalsIgnoreCase(act2);
    }

    @SuppressWarnings("unchecked")
    public <T> T getActivityByName(String activity) {
        if (ActivityStack.instance().currentActivity().getClass().getCanonicalName().equalsIgnoreCase(activity)) {
            return (T) ActivityStack.instance().currentActivity();
        }
        return null;
    }

}