package cayte.frame;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import cayte.frame.act.ActivityStack;
import cayte.frame.init.C;

public abstract class BaseExitApp {

	protected abstract void _close();

	public void closeApp() {
		_close();
		ActivityStack.instance().popAllActivity();
	}

	public <T> void closeService(Class<T> service) {
		if (service == null)
			return;
		Intent intent = new Intent(C.context, service);
		C.context.stopService(intent);
	}

	protected abstract void _kill();

	public void killApp() {
		killApp(false);
	}

	public void killApp(boolean isKillClear) {
		_kill();
		ActivityManager am = (ActivityManager) C.context.getSystemService(Context.ACTIVITY_SERVICE);
		am.killBackgroundProcesses(C.context.getPackageName());
		if (isKillClear) {
			android.os.Process.killProcess(android.os.Process.myPid());
			System.exit(0);
		}
	}

}
