package cayte.frame;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;

import java.util.List;

import cayte.frame.helper.ApplicationCrashHelper;
import cayte.frame.helper.ApplicationCrashHelper.OnUncaughtException;
import cayte.frame.init.C;
import cayte.frame.log.D;

public abstract class BaseApp extends Application {

    @Override
    public void onCreate() {
        super.onCreate();
        C.init(this);
        D.init(this);
        // 启动捕捉全局异常
        OnUncaughtException onUncaught = new OnUncaughtException() {

            @Override
            public void onUncaughtException(String... texts) {
                D.e("================= error =================");
                StringBuffer error = new StringBuffer();
                for (String s : texts) {
                    D.e(s);
                    error.append(s);
                    error.append("\n");
                }
                _onUncaughtException(error.toString());
            }
        };
        ApplicationCrashHelper handler = ApplicationCrashHelper.instance();
        handler.init(getApplicationContext(), onUncaught);
        Thread.setDefaultUncaughtExceptionHandler(handler);
        //
        if (isMainProcess())
            _onCreate();
    }

    protected abstract void _onCreate();

    protected abstract void _onUncaughtException(String error);

    protected String getProcessName() {
        ActivityManager am = (ActivityManager) getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningAppProcessInfo> runningApps = am.getRunningAppProcesses();
        if (runningApps != null)
            for (ActivityManager.RunningAppProcessInfo procInfo : runningApps) {
                if (procInfo.pid == android.os.Process.myPid()) {
                    return procInfo.processName;
                }
            }
        return null;
    }

    protected boolean isMainProcess() {
        return getPackageName().equals(getProcessName());
    }

}