/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.util;

import cayte.frame.data.BaseObject;
import cayte.frame.file.F;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class ObjectUtils {
    public static BaseObject readObj(String filePath) throws Exception {
        return (BaseObject)ObjectUtils.read(filePath);
    }

    public static void writeObj(String filePath, BaseObject obj) throws Exception {
        ObjectUtils.write(filePath, obj);
    }

    public static <T> List<T> readObjList(String filePath) {
        ArrayList<Object> list = null;
        try {
            Object[] arr = (Object[])ObjectUtils.read(filePath);
            list = new ArrayList<Object>();
            int j = arr.length;
            for (int i = 0; i < j; ++i) {
                list.add(arr[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static <T> void writeObjList(String filePath, List<T> objList) {
        try {
            ObjectUtils.write(filePath, objList.toArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeObjList(String filePath, BaseObject[] arr) {
        try {
            ObjectUtils.write(filePath, arr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object read(String filePath) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filePath));
        Object obj = ois.readObject();
        ois.close();
        return obj;
    }

    private static void write(String filePath, Object obj) throws Exception {
        File f = new File(filePath);
        F.checkFolder(f.getParent());
        if (f.exists()) {
            f.delete();
        }
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(f));
        os.writeObject(obj);
        os.close();
    }
}

