/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.ui;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import cayte.frame.ui.UIActivity;
import cayte.frame.ui.UITabInterface;

public class UITabActivity<T extends Activity, E extends UITabInterface>
extends UIActivity<T, E> {
    public int currentFragmentId = -1;

    public UITabActivity(T a, E ai) {
        super(a, ai);
    }

    public void replaceFragment(int fgId, Fragment fragment, boolean isBack) {
        fragment.setArguments(this.a.getIntent().getExtras());
        FragmentTransaction transaction = this.a.getFragmentManager().beginTransaction();
        transaction.replace(((UITabInterface)this.ai).containerViewId(), fragment, String.valueOf(fgId));
        if (isBack) {
            transaction.addToBackStack(String.valueOf(fgId));
        }
        this.currentFragmentId = fgId;
        transaction.commit();
    }

    public void addFragment(int fgId, Fragment fragment, boolean isHide) {
        fragment.setArguments(this.a.getIntent().getExtras());
        FragmentTransaction transaction = this.a.getFragmentManager().beginTransaction();
        transaction.add(((UITabInterface)this.ai).containerViewId(), fragment, String.valueOf(fgId));
        if (isHide) {
            transaction.hide(fragment);
        } else {
            this.currentFragmentId = fgId;
        }
        transaction.commitAllowingStateLoss();
    }

    public void toFragment(int fgId) {
        FragmentTransaction transaction = this.a.getFragmentManager().beginTransaction();
        if (this.currentFragmentId >= 0 && this.getFragment(this.currentFragmentId) != null) {
            transaction.hide(this.getFragment(this.currentFragmentId));
        }
        this.currentFragmentId = fgId;
        if (this.getFragment(this.currentFragmentId) != null) {
            transaction.show(this.getFragment(this.currentFragmentId));
        }
        transaction.commitAllowingStateLoss();
    }

    public Fragment getFragment(int fgId) {
        Fragment frag = this.a.getFragmentManager().findFragmentByTag(String.valueOf(fgId));
        if (frag == null) {
            return null;
        }
        return frag;
    }

    public Fragment getCurrentFragment() {
        if (this.currentFragmentId >= 0) {
            return this.getFragment(this.currentFragmentId);
        }
        return null;
    }
}

