/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.ui;

import android.app.Activity;
import android.app.Fragment;
import android.os.AsyncTask;
import android.view.LayoutInflater;
import android.view.View;
import cayte.frame.manager.IsRefreshManager;
import cayte.frame.task.GenericTask;
import cayte.frame.task.TaskManager;
import cayte.frame.ui.UIFragmentInterface;
import cayte.frame.ui.UITabInterface;

public class UIFragment<T extends Fragment, E extends UIFragmentInterface> {
    public LayoutInflater inflater = null;
    public E ai;
    public UITabInterface onFragmentListener = null;
    protected T a;
    protected TaskManager taskManager = null;

    public UIFragment(T a, E ai) {
        this.a = a;
        this.ai = ai;
        this.onFragmentListener = (UITabInterface)a.getActivity();
    }

    public Activity getA() {
        return this.a.getActivity();
    }

    public T getF() {
        return this.a;
    }

    public void onCreate() {
        this.taskManager = new TaskManager();
        this.inflater = (LayoutInflater)this.a.getActivity().getSystemService("layout_inflater");
    }

    public void onResume() {
        this.ai.refresh(IsRefreshManager.instance().get(this.a.getClass()), new Object[0]);
    }

    public void onDestroy() {
        this.cancelAllTask();
        this.taskManager.deleteObservers();
        this.taskManager = null;
        this.inflater = null;
    }

    public void onHiddenChanged(boolean hidden) {
        if (hidden) {
            this.ai.onHideFragment();
        } else {
            this.ai.refresh(IsRefreshManager.instance().get(this.a.getClass()), new Object[0]);
            this.ai.onShowFragment();
        }
    }

    public void setVisibility(int visible, View ... views) {
        for (View v : views) {
            v.setVisibility(visible);
        }
    }

    public void setClickListener(View.OnClickListener click, View ... views) {
        for (View v : views) {
            v.setOnClickListener(click);
        }
    }

    public void execute(GenericTask<?> genericTask) {
        if (genericTask.getStatus() != AsyncTask.Status.PENDING) {
            return;
        }
        genericTask.execute(new Object[0]);
        this.taskManager.addTask(genericTask);
    }

    public <T> void execute(GenericTask<T> genericTask, T ... params) {
        if (genericTask.getStatus() != AsyncTask.Status.PENDING) {
            return;
        }
        genericTask.execute(params);
        this.taskManager.addTask(genericTask);
    }

    public void cancelAllTask() {
        this.taskManager.cancelAll();
    }
}

