/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.task;

import android.os.AsyncTask;
import cayte.frame.task.TaskListener;
import cayte.frame.task.TaskManager;
import cayte.frame.task.TaskProgress;
import cayte.frame.task.TaskResult;
import java.util.Observable;
import java.util.Observer;

public abstract class GenericTask<T>
extends AsyncTask<T, TaskProgress, TaskResult>
implements Observer {
    protected TaskListener mListener = null;
    protected boolean isCancelable = false;

    protected abstract TaskResult _doInBackground(T ... var1);

    public void setListener(TaskListener taskListener) {
        this.mListener = taskListener;
    }

    public TaskListener getListener() {
        return this.mListener;
    }

    protected void onCancelled() {
        this.isCancelable = true;
        super.onCancelled();
        try {
            if (this.mListener != null) {
                this.mListener.onCancelled();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onPreExecute() {
        super.onPreExecute();
        try {
            if (this.mListener != null) {
                this.mListener.onPreExecute();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected TaskResult doInBackground(T ... params) {
        TaskResult result = this._doInBackground(params);
        return result;
    }

    protected void onProgressUpdate(TaskProgress ... values) {
        super.onProgressUpdate((Object[])values);
        try {
            if (this.mListener != null && values != null && values.length > 0) {
                this.mListener.onProgressUpdate(values);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onPostExecute(TaskResult result) {
        super.onPostExecute((Object)result);
        try {
            if (this.mListener != null) {
                this.mListener.onPostExecute(result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (TaskManager.CANCEL_ALL == (Integer)arg && !this.isCancelable) {
            this.isCancelable = true;
            if (this.getStatus() == AsyncTask.Status.RUNNING) {
                this.cancel(true);
            }
        }
    }
}

