/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.log;

import android.annotation.SuppressLint;
import android.os.Environment;
import cayte.frame.file.F;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

@SuppressLint(value={"SimpleDateFormat"})
public class L {
    private static String LOG_DIR = null;
    private static int CLEAR_DAYS = 7;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String logName;

    public static void logDir(String logDir) {
        LOG_DIR = logDir;
    }

    public static void logName(String logName) {
        L.logName = logName;
    }

    public static String getLogName() {
        if (logName == null || logName.equals("")) {
            logName = "log";
        }
        return logName;
    }

    public static void clearDays(int days) {
        CLEAR_DAYS = days;
    }

    private static String getLogPath() {
        if (LOG_DIR == null) {
            LOG_DIR = F.getCache("log");
        }
        String name = L.getLogName() + "_" + new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis())) + ".txt";
        return LOG_DIR + name;
    }

    private static String getTimeString() {
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    public static void log(String name, String tag, String log) {
        L.doLog(L.getTimeString() + "\t" + name + "\t" + tag + "\t" + log);
    }

    public static void log(String name, String tag, String log, Throwable tr) {
        L.logMulti(name, tag, log + "\n" + L.getErrorInfo(tr));
    }

    public static void logMulti(String name, String tag, String log) {
        String[] logs;
        for (String l : logs = log.split("\n")) {
            if (l == null || l.equals("")) continue;
            L.log(name, tag, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doLog(String log) {
        OutputStreamWriter filerWriter = null;
        BufferedWriter bufWriter = null;
        try {
            boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
            if (!sdCardExist) {
                return;
            }
            File logFile = new File(L.getLogPath());
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            filerWriter = new FileWriter(logFile, true);
            bufWriter = new BufferedWriter(filerWriter);
            bufWriter.write(log);
            bufWriter.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                filerWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getErrorInfo(Throwable tr) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        tr.printStackTrace(pw);
        pw.close();
        String error = ((Object)writer).toString().trim();
        return error;
    }

    public static void clear() {
        long day = 86400000L;
        long time = System.currentTimeMillis();
        for (int i = 0; i < CLEAR_DAYS; ++i) {
            L.clearDay(time - day * (long)i);
        }
    }

    public static void clearDay(long timeMillis) {
        String today = new SimpleDateFormat("yyyy-MM-dd").format(timeMillis) + ".txt";
        File dir = new File(LOG_DIR);
        dir.mkdirs();
        File[] list = dir.listFiles();
        if (list != null) {
            for (File file : list) {
                if (file.getName().endsWith(today)) continue;
                file.delete();
            }
        }
    }

    public static String getLogDir() {
        return LOG_DIR;
    }
}

