/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.file;

import android.os.Environment;
import cayte.frame.file.FolderUtils;
import cayte.frame.init.C;
import java.io.File;

public class F {
    private static final String FILE = "file";
    private static final String CACHE = "cache";
    public static String customDirName = C.context.getPackageName();
    private static String userDirName = null;
    private static M defaultMode = M.app;

    public static void defaultMode(M mode) {
        defaultMode = mode;
    }

    public static void customDirName(String customDirName) {
        F.customDirName = customDirName;
    }

    public static boolean isSDExist() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static String getSDPath() {
        return Environment.getExternalStorageDirectory().getPath() + File.separator;
    }

    public static String getFilePath4app() {
        return C.context.getFilesDir().getPath() + File.separator;
    }

    public static String getFilePath4SDAndroid() {
        if (F.isSDExist()) {
            return F.getSDPath() + "Android" + File.separator + "data" + File.separator + C.context.getPackageName() + File.separator + FILE + File.separator;
        }
        return F.getFilePath4app();
    }

    public static String getFilePath4SDCustom() {
        if (F.isSDExist()) {
            return F.getSDPath() + customDirName + File.separator + FILE + File.separator;
        }
        return F.getFilePath4app();
    }

    public static String getCachePath4app() {
        return C.context.getCacheDir().getPath() + File.separator;
    }

    public static String getCachePath4SDAndroid() {
        if (F.isSDExist()) {
            return F.getSDPath() + "Android" + File.separator + "data" + File.separator + C.context.getPackageName() + File.separator + CACHE + File.separator;
        }
        return F.getCachePath4app();
    }

    public static String getCachePath4SDCustom() {
        if (F.isSDExist()) {
            return F.getSDPath() + customDirName + File.separator + CACHE + File.separator;
        }
        return F.getCachePath4app();
    }

    public static String getFilePath() {
        return F.getFilePath(defaultMode);
    }

    public static String getFilePath(M mode) {
        String root = null;
        switch (mode) {
            default: {
                root = F.getFilePath4app();
                break;
            }
            case SDAndroid: {
                root = F.getFilePath4SDAndroid();
                break;
            }
            case SDCustom: {
                root = F.getFilePath4SDCustom();
            }
        }
        if (F.checkFolder(root)) {
            return root;
        }
        defaultMode = M.app;
        root = F.getFilePath4app();
        return root;
    }

    public static String getCachePath() {
        return F.getCachePath(defaultMode);
    }

    public static String getCachePath(M mode) {
        String root = null;
        switch (mode) {
            default: {
                root = F.getCachePath4app();
                break;
            }
            case SDAndroid: {
                root = F.getCachePath4SDAndroid();
                break;
            }
            case SDCustom: {
                root = F.getCachePath4SDCustom();
            }
        }
        if (F.checkFolder(root)) {
            return root;
        }
        defaultMode = M.app;
        root = F.getCachePath4app();
        return root;
    }

    public static String getFile(String mark) {
        return F.getFile(defaultMode, mark);
    }

    public static String getFile(M mode, String mark) {
        String path = F.getFilePath(mode) + mark + File.separator;
        F.checkFolder(path);
        return path;
    }

    public static String getCache(String mark) {
        return F.getCache(defaultMode, mark);
    }

    public static String getCache(M mode, String mark) {
        String path = F.getCachePath(mode) + mark + File.separator;
        F.checkFolder(path);
        return path;
    }

    public static void loginUser(String id) {
        userDirName = "USER_" + id;
    }

    public static void logoutUser() {
        userDirName = null;
    }

    public static String getUserFile() {
        if (userDirName == null) {
            return null;
        }
        return F.getFile(userDirName);
    }

    public static String getUserCache() {
        if (userDirName == null) {
            return null;
        }
        return F.getCache(userDirName);
    }

    public static boolean checkFolder(String path) {
        return FolderUtils.checkFolder(path);
    }

    public static void deleteFile(String path) {
        FolderUtils.deleteFile(path);
    }

    public static void deleteFile(File file) {
        FolderUtils.deleteFile(file.getPath());
    }

    public static void clearCache() {
        F.deleteFile(F.getCachePath());
    }

    public static enum M {
        app,
        SDAndroid,
        SDCustom;

    }
}

