/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.view.View;
import cayte.frame.dialog.DialogListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BaseDialogHelper {
    protected Map<String, Dialog> ads = new HashMap<String, Dialog>();

    private void addDialog(final String key, Dialog d, final DialogListener l) {
        d.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                BaseDialogHelper.this.ads.remove(key);
                if (l != null) {
                    l.onDismiss();
                }
            }
        });
        this.ads.put(key, d);
    }

    protected void showDialog(String key, Dialog d) {
        this.showDialog(key, d, null);
    }

    protected void showDialog(String key, Dialog d, DialogListener l) {
        this.addDialog(key, d, l);
        d.show();
    }

    protected void dismissDialog(String key) {
        Dialog dialog;
        if (this.ads.containsKey(key) && (dialog = this.ads.remove(key)) != null) {
            dialog.dismiss();
        }
    }

    protected boolean checkDialog(String key) {
        if (!this.ads.containsKey(key)) {
            return true;
        }
        if (this.ads.get(key) == null) {
            this.ads.remove(key);
            return true;
        }
        if (!this.ads.get(key).isShowing()) {
            this.ads.remove(key);
            return true;
        }
        return false;
    }

    protected View findDialogView(String key, int id) {
        Dialog dialog;
        if (this.ads.containsKey(key) && (dialog = this.ads.get(key)) != null && dialog.isShowing()) {
            return dialog.findViewById(id);
        }
        return null;
    }

    public void clear() {
        Set<String> keys = this.ads.keySet();
        for (String key : keys) {
            Dialog dialog = this.ads.remove(key);
            if (dialog == null) continue;
            dialog.dismiss();
        }
    }
}

