/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.data;

import android.os.Bundle;
import cayte.frame.data.BaseObject;
import cayte.frame.log.D;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class DataPool {
    public static final String TAG = DataPool.class.getCanonicalName();
    private static final boolean DEFAULT_LIMIT = false;
    private static DataPool dataPool = null;
    private static HashMap<String, Boolean> limits = null;
    private static Bundle cache = null;

    public DataPool() {
        limits = new HashMap();
        cache = new Bundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataPool instance() {
        if (dataPool != null) return dataPool;
        Class<DataPool> clazz = DataPool.class;
        synchronized (DataPool.class) {
            if (dataPool != null) return dataPool;
            dataPool = new DataPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dataPool;
        }
    }

    public void remove(String key) {
        limits.remove(key);
        cache.remove(key);
    }

    private void checkLimit(String key) {
        boolean limit;
        boolean bl = limit = limits.get(key) == null ? false : limits.get(key);
        if (limit) {
            limits.remove(key);
            cache.remove(key);
        }
    }

    public void clear() {
        limits.clear();
        cache.clear();
    }

    public void put(String key, BaseObject obj) {
        this.put(key, obj, false);
    }

    public void put(String key, BaseObject obj, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putSerializable(key, (Serializable)obj);
        limits.put(key, limit);
    }

    public BaseObject getBaseObj(String key) {
        if (key == null) {
            return null;
        }
        Serializable obj = null;
        obj = cache.getSerializable(key);
        if (obj == null) {
            D.e(TAG, "getBaseObj --> the value is null.");
            return null;
        }
        this.checkLimit(key);
        return (BaseObject)obj;
    }

    public void put(String key, List<?> objList) {
        this.put(key, objList, false);
    }

    public void put(String key, List<?> objList, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putSerializable(key, (Serializable)((Object)objList));
        limits.put(key, limit);
    }

    public <T> List<T> getListBaseObj(String key) {
        if (key == null) {
            return null;
        }
        Serializable obj = null;
        obj = cache.getSerializable(key);
        if (obj == null) {
            D.e(TAG, "getArrayBaseObj --> the value is null.");
            return null;
        }
        this.checkLimit(key);
        return (List)((Object)obj);
    }

    public void put(String key, int integer) {
        this.put(key, integer, false);
    }

    public void put(String key, int integer, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putInt(key, integer);
        limits.put(key, limit);
    }

    public int getInteger(String key) {
        if (key == null) {
            return 0;
        }
        int integer = cache.getInt(key);
        this.checkLimit(key);
        return integer;
    }

    public void put(String key, int[] integerArray) {
        this.put(key, integerArray, false);
    }

    public void put(String key, int[] integerArray, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putIntArray(key, integerArray);
        limits.put(key, limit);
    }

    public int[] getArrayInteger(String key) {
        if (key == null) {
            return null;
        }
        int[] integerArray = cache.getIntArray(key);
        if (integerArray == null) {
            D.e(TAG, "getArrayInteger --> the value is null.");
            return null;
        }
        this.checkLimit(key);
        return integerArray;
    }

    public void put(String key, String string) {
        this.put(key, string, false);
    }

    public void put(String key, String string, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putString(key, string);
        limits.put(key, limit);
    }

    public String getString(String key) {
        if (key == null) {
            return null;
        }
        String string = cache.getString(key);
        if (string == null) {
            D.e(TAG, "getString --> the value is null.");
            return null;
        }
        this.checkLimit(key);
        return string;
    }

    public void put(String key, String[] stringArray) {
        this.put(key, stringArray, false);
    }

    public void put(String key, String[] stringArray, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putStringArray(key, stringArray);
        limits.put(key, limit);
    }

    public String[] getArrayString(String key) {
        if (key == null) {
            return null;
        }
        String[] stringArray = cache.getStringArray(key);
        if (stringArray == null) {
            D.e(TAG, "getArrayString --> the value is null.");
            return null;
        }
        this.checkLimit(key);
        return stringArray;
    }
}

