/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.act;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import cayte.frame.data.BaseObject;
import java.io.Serializable;

public class Screen {
    private Context from;
    private Class<?> to;
    private String action;
    private String packageName;
    private Intent intent = null;

    public static Screen create() {
        return new Screen();
    }

    public Screen from(Context con) {
        this.from = con;
        return this;
    }

    public Screen to(Class<?> cls) {
        this.to = cls;
        return this;
    }

    public Screen action(String action) {
        this.action = action;
        return this;
    }

    public Screen intent(Intent intent) {
        this.intent = intent;
        return this;
    }

    public Intent getIntent() {
        if (this.intent == null) {
            if (this.from != null && this.to != null) {
                this.intent = new Intent(this.from, this.to);
            } else if (this.action != null) {
                if (this.intent == null) {
                    this.intent = new Intent(this.action);
                } else {
                    this.intent.setAction(this.action);
                }
            }
            if (this.packageName != null) {
                this.intent.setPackage(this.packageName);
            }
        }
        return this.intent;
    }

    public Screen setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public Screen putExtra(String name, CharSequence value) {
        this.getIntent().putExtra(name, value);
        return this;
    }

    public Screen putExtra(String name, String value) {
        this.getIntent().putExtra(name, value);
        return this;
    }

    public Screen putExtra(String name, int value) {
        this.getIntent().putExtra(name, value);
        return this;
    }

    public Screen putExtra(String name, boolean value) {
        this.getIntent().putExtra(name, value);
        return this;
    }

    public Screen putExtra(String name, double value) {
        this.getIntent().putExtra(name, value);
        return this;
    }

    public Screen putExtra(String name, float value) {
        this.getIntent().putExtra(name, value);
        return this;
    }

    public Screen putExtra(String name, short value) {
        this.getIntent().putExtra(name, value);
        return this;
    }

    public Screen putExtra(String name, long value) {
        this.getIntent().putExtra(name, value);
        return this;
    }

    public Screen putExtra(String name, Parcelable value) {
        this.getIntent().putExtra(name, value);
        return this;
    }

    public Screen putExtra(String name, Serializable value) {
        this.getIntent().putExtra(name, value);
        return this;
    }

    public Screen putExtra(String name, Bundle value) {
        this.getIntent().putExtra(name, value);
        return this;
    }

    public Screen putBean(BaseObject value) {
        return this.putBean("bean", value);
    }

    public Screen putBean(String name, BaseObject value) {
        this.getIntent().putExtra(name, (Serializable)value);
        return this;
    }

    public Screen addFlag(int flags) {
        this.getIntent().addFlags(flags);
        return this;
    }

    public Screen setFlag(int flags) {
        this.getIntent().setFlags(flags);
        return this;
    }

    public Screen setData(Uri data) {
        this.getIntent().setData(data);
        return this;
    }

    public Screen setDataAndType(Uri data, String type) {
        this.getIntent().setDataAndType(data, type);
        return this;
    }

    public void start() {
        this.from.startActivity(this.getIntent());
    }

    public void startService() {
        this.from.startService(this.getIntent());
    }

    public void startForResult(int requestCode) {
        if (this.from instanceof Activity) {
            ((Activity)this.from).startActivityForResult(this.getIntent(), requestCode);
        }
    }
}

