/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Process;
import cayte.frame.helper.ApplicationCrashHelper;
import cayte.frame.init.C;
import cayte.frame.log.D;
import java.util.List;

public abstract class BaseApp
extends Application {
    public void onCreate() {
        super.onCreate();
        C.init(this);
        D.init((Context)this);
        ApplicationCrashHelper.OnUncaughtException onUncaught = new ApplicationCrashHelper.OnUncaughtException(){

            @Override
            public void onUncaughtException(String ... texts) {
                D.e("================= error =================");
                StringBuffer error = new StringBuffer();
                for (String s : texts) {
                    D.e(s);
                    error.append(s);
                    error.append("\n");
                }
                BaseApp.this._onUncaughtException(error.toString());
            }
        };
        ApplicationCrashHelper handler = ApplicationCrashHelper.instance();
        handler.init(this.getApplicationContext(), onUncaught);
        Thread.setDefaultUncaughtExceptionHandler(handler);
        if (this.isMainProcess()) {
            this._onCreate();
        }
    }

    protected abstract void _onCreate();

    protected abstract void _onUncaughtException(String var1);

    protected String getProcessName() {
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        List runningApps = am.getRunningAppProcesses();
        if (runningApps != null) {
            for (ActivityManager.RunningAppProcessInfo procInfo : runningApps) {
                if (procInfo.pid != Process.myPid()) continue;
                return procInfo.processName;
            }
        }
        return null;
    }

    protected boolean isMainProcess() {
        return this.getPackageName().equals(this.getProcessName());
    }
}

