package cayte.frame.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

import cayte.frame.data.BaseObject;
import cayte.frame.file.F;

public class ObjectUtils {

    public static BaseObject readObj(String filePath) throws Exception {
        return (BaseObject) read(filePath);
    }

    public static void writeObj(String filePath, BaseObject obj) throws Exception {
        write(filePath, obj);
    }

    @SuppressWarnings("unchecked")
    public static <T> List<T> readObjList(String filePath) {
        List<T> list = null;
        try {
            Object[] arr = (Object[]) read(filePath);
            list = new ArrayList<T>();
            for (int i = 0, j = arr.length; i < j; i++) {
                list.add((T) arr[i]);
            }
        } catch (Exception e) {
        }
        return list;
    }

    public static <T> void writeObjList(String filePath, List<T> objList) {
        try {
            write(filePath, objList.toArray());
        } catch (Exception e) {
        }
    }

    public static void writeObjList(String filePath, BaseObject[] arr) {
        try {
            write(filePath, arr);
        } catch (Exception e) {
        }
    }

    private static Object read(String filePath) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filePath));
        Object obj = ois.readObject();
        ois.close();
        return obj;
    }

    private static void write(String filePath, Object obj) throws Exception {
        File f = new File(filePath);
        F.checkFolder(f.getParent());
        if (f.exists())
            f.delete();
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(f));
        os.writeObject(obj);
        os.close();
    }
}
