package cayte.frame.util;

import cayte.frame.helper.MobileParams;

public class DisplayUtils {

	public static int px2dip(float pxValue) {
		return px2dip(pxValue, MobileParams.instance().scale);
	}

	public static int dip2px(float dipValue) {
		return dip2px(dipValue, MobileParams.instance().scale);
	}

	public static int px2sp(float pxValue) {
		return px2sp(pxValue, MobileParams.instance().fontScale);
	}

	public static int sp2px(float spValue) {
		return sp2px(spValue, MobileParams.instance().fontScale);
	}

	public static int px2dip(float pxValue, float scale) {
		return (int) (pxValue / scale + 0.5f);
	}

	public static int dip2px(float dipValue, float scale) {
		return (int) (dipValue * scale + 0.5f);
	}

	public static int px2sp(float pxValue, float fontScale) {
		return (int) (pxValue / fontScale + 0.5f);
	}

	public static int sp2px(float spValue, float fontScale) {
		return (int) (spValue * fontScale + 0.5f);
	}
}
