package cayte.frame.util;

import android.annotation.SuppressLint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

@SuppressLint("SimpleDateFormat")
public class DateUtils {

	public static DateFormat getDateFormat(String pattern) {
		return new SimpleDateFormat(pattern);
	}

	public static boolean dateCheck(int year, int month, int day) {
		DateFormat format = getDateFormat("yyyy-MM-dd");
		try {
			Date today = format.parse(format.format(new Date()));
			Date date = format.parse(year + "-" + month + "-" + day);
			if (date.getTime() >= today.getTime())
				return true;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	public static boolean isToday(Date date) {
		DateFormat format = getDateFormat("yyyy-MM-dd");
		return isToday(format.format(date));
	}

	public static boolean isToday(int year, int month, int day) {
		return isToday(year + "-" + month + "-" + day);
	}

	public static boolean isToday(String d) {
		DateFormat format = getDateFormat("yyyy-MM-dd");
		try {
			Date today = format.parse(format.format(new Date()));
			Date date = format.parse(d);
			if (date.getTime() == today.getTime())
				return true;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	public static boolean isAfterToday(int year, int month, int day, int hour, int minutes) {
		DateFormat format = getDateFormat("yyyy-MM-dd HH:mm");
		try {
			Date date = format.parse(year + "-" + month + "-" + day + " " + hour + ":" + minutes);
			if (date.getTime() > System.currentTimeMillis())
				return true;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

}
