package cayte.frame.util;

import android.annotation.SuppressLint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class CalendarUtils {

	public static int firstDayOfWeek = Calendar.SUNDAY;

	@SuppressLint("SimpleDateFormat")
	public static DateFormat getDateFormat(String pattern) {
		DateFormat dateFormat = new SimpleDateFormat(pattern);
		return dateFormat;
	}

	public static void printCalendar(String tag, Calendar c) {
		System.out.println(
				tag + ">>>" + c.get(Calendar.YEAR) + "-" + c.get(Calendar.MONTH) + "-" + c.get(Calendar.DAY_OF_MONTH));
	}

	public static Calendar getTodayCalendar() {
		Calendar calendar = getCalendar(System.currentTimeMillis());
		return calendar;
	}

	public static Calendar getCalendar() {
		Calendar calendar = Calendar.getInstance();
		calendar.clear();
		calendar.setFirstDayOfWeek(firstDayOfWeek);
		return calendar;
	}

	public static Calendar getCalendar(long timeInMillis) {
		Calendar calendar = getCalendar();
		return setTimeInMillis(calendar, timeInMillis);
	}

	public static Calendar getCalendar(int year, int month, int day) {
		Calendar calendar = getCalendar();
		calendar.set(Calendar.YEAR, year);
		calendar.set(Calendar.MONTH, month);
		calendar.set(Calendar.DAY_OF_MONTH, day);
		return calendar;
	}

	public static Calendar setTimeInMillis(Calendar calendar, long timeInMillis) {
		calendar.setTimeInMillis(timeInMillis);
		return clearTime(calendar);
	}

	public static Calendar clearTime(Calendar calendar) {
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		return calendar;
	}

	public static Calendar getMonthCalendar(int index, long timeInMillis) {
		Calendar calendar = getCalendar(timeInMillis);
		calendar.add(Calendar.MONTH, index);
		return calendar;
	}

	public static Calendar getWeekCalendar(int index, long timeInMillis) {
		Calendar calendar = getCalendar(timeInMillis);
		calendar.add(Calendar.WEEK_OF_YEAR, index);
		return calendar;
	}

	public static Calendar copyCalendar(Calendar calendar) {
		return getCalendar(calendar.getTimeInMillis());
	}

	public static boolean sameDay(Calendar c1, Calendar c2) {
		if (c1 != null && c2 != null)
			if (c1.get(Calendar.YEAR) == c2.get(Calendar.YEAR) && c1.get(Calendar.MONTH) == c2.get(Calendar.MONTH)
					&& c1.get(Calendar.DAY_OF_MONTH) == c2.get(Calendar.DAY_OF_MONTH))
				return true;
		return false;
	}

	public static boolean sameDay(Calendar c, int year, int month, int day) {
		if (c != null)
			if (c.get(Calendar.YEAR) == year && c.get(Calendar.MONTH) == month && c.get(Calendar.DAY_OF_MONTH) == day)
				return true;
		return false;
	}

	public static int getDiffMonth4Calendar(long initTime, Calendar day) {
		Calendar calendarFirst = getCalendar(initTime);
		calendarFirst.set(Calendar.DAY_OF_MONTH, 1);
		//
		Calendar calendar = copyCalendar(day);
		calendar.set(Calendar.DAY_OF_MONTH, 1);
		//
		int index = 0;
		if (calendar.compareTo(calendarFirst) < 0) {
			while (calendar.compareTo(calendarFirst) < 0) {
				index--;
				calendar.add(Calendar.MONTH, 1);
			}
		} else {
			while (calendar.compareTo(calendarFirst) > 0) {
				index++;
				calendar.add(Calendar.MONTH, -1);
			}
		}
		return index;
	}

	public static int getDiffWeek4Calendar(long initTime, Calendar day) {
		Calendar calendarFirst = getCalendar(initTime);
		calendarFirst.add(Calendar.DAY_OF_WEEK, firstDayOfWeek - calendarFirst.get(Calendar.DAY_OF_WEEK));
		//
		Calendar calendar = copyCalendar(day);
		calendar.add(Calendar.DAY_OF_WEEK, firstDayOfWeek - calendar.get(Calendar.DAY_OF_WEEK));
		//
		int index = 0;
		if (calendar.compareTo(calendarFirst) < 0) {
			while (calendar.compareTo(calendarFirst) < 0) {
				index--;
				calendar.add(Calendar.WEEK_OF_YEAR, 1);
			}
		} else {
			while (calendar.compareTo(calendarFirst) > 0) {
				index++;
				calendar.add(Calendar.WEEK_OF_YEAR, -1);
			}
		}
		return index;
	}

}
