package cayte.frame.util;

import java.util.List;

import android.app.ActivityManager;
import android.app.ActivityManager.RunningAppProcessInfo;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;

public class AppUtils {

	public static boolean isAndroid40() {
		return Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH;
	}

	public static boolean isAndroid44() {
		return Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT;
	}

	public static boolean isAndroid50() {
		return Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP;
	}

	public static boolean isAndroid60() {
		return Build.VERSION.SDK_INT >= Build.VERSION_CODES.M;
	}

	public static int getVersionCode(Context con) {
		try {
			PackageManager manager = con.getApplicationContext().getPackageManager();
			PackageInfo info = manager.getPackageInfo(con.getPackageName(), 0);
			return info.versionCode;
		} catch (Exception e) {
			e.printStackTrace();
			return 0;
		}
	}

	public static String getVersionName(Context con) {
		try {
			PackageManager manager = con.getApplicationContext().getPackageManager();
			PackageInfo info = manager.getPackageInfo(con.getPackageName(), 0);
			return info.versionName;
		} catch (Exception e) {
			e.printStackTrace();
			return "0.0";
		}
	}

	/**
	 * 当前程序是否在前台运行
	 * 
	 * @param con
	 *            当前程序的context
	 * @return true yes,otherwise no
	 */
	public static boolean isAppOnForeground(Context con) {
		ActivityManager activityManager = (ActivityManager) con.getSystemService(Context.ACTIVITY_SERVICE);
		String packageName = con.getPackageName();
		List<RunningAppProcessInfo> appProcesses = activityManager.getRunningAppProcesses();
		if (appProcesses == null)
			return false;
		for (RunningAppProcessInfo appProcess : appProcesses) {
			if (appProcess.processName.equals(packageName)
					&& appProcess.importance == RunningAppProcessInfo.IMPORTANCE_FOREGROUND) {
				return true;
			}
		}
		return false;
	}

}
