package cayte.frame.ui.v4;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;

import cayte.frame.ui.UIActivity;

public class UIV4TabActivity<T extends AppCompatActivity, E extends UIV4TabInterface> extends UIActivity<T, E> {

    /**
     * 记录当前Fragment的id
     */
    public int currentFragmentId = -1;

    /**
     * 实例化
     *
     * @param a  a extends Activity
     * @param ai ai implements UIInterface
     */
    public UIV4TabActivity(T a, E ai) {
        super(a, ai);
    }

    /**
     * 替换Fragment,参见FragmentTransaction.replace<br>
     * 单独使用
     *
     * @param fgId     需要替换的Fragment id
     * @param fragment 需要替换的Fragment
     * @param isBack   是否可返回
     */
    public void replaceFragment(int fgId, Fragment fragment, boolean isBack) {
        fragment.setArguments(a.getIntent().getExtras());
        FragmentTransaction transaction = a.getSupportFragmentManager().beginTransaction();
        transaction.replace(ai.containerViewId(), fragment, String.valueOf(fgId));
        if (isBack)
            transaction.addToBackStack(String.valueOf(fgId));
        this.currentFragmentId = fgId;
        transaction.commit();
    }

    /**
     * 替换Fragment,参见FragmentTransaction.add<br>
     * 与toFragment方法同用
     *
     * @param fgId     添加Fragment的id
     * @param fragment 添加的Fragment
     * @param isHide   初始是否隐藏,添加的集合中只能有一个显示
     */
    public void addFragment(int fgId, Fragment fragment, boolean isHide) {
        fragment.setArguments(a.getIntent().getExtras());
        FragmentTransaction transaction = a.getSupportFragmentManager().beginTransaction();
        transaction.add(ai.containerViewId(), fragment, String.valueOf(fgId));
        if (isHide) {
            transaction.hide(fragment);
        } else {
            this.currentFragmentId = fgId;
        }
        transaction.commitAllowingStateLoss();
    }

    /**
     * 显示Fragment<br>
     * 与addFragment方法同用
     *
     * @param fgId 需要显示Fragment的id
     */
    public void toFragment(int fgId) {
        FragmentTransaction transaction = a.getSupportFragmentManager().beginTransaction();
        if (currentFragmentId >= 0) {
            if (getFragment(currentFragmentId) != null)
                transaction.hide(getFragment(currentFragmentId));
        }
        this.currentFragmentId = fgId;
        if (getFragment(currentFragmentId) != null)
            transaction.show(getFragment(currentFragmentId));
        transaction.commitAllowingStateLoss();
    }

    /**
     * 可通过Fragment的id获取FragmentManager中的Fragment
     *
     * @param fgId 需要获取的Fragment的id
     * @return 目标Fragment或是null
     */
    public Fragment getFragment(int fgId) {
        Fragment frag = a.getSupportFragmentManager().findFragmentByTag(String.valueOf(fgId));
        if (frag == null) {
            return null;
        }
        return frag;
    }

    /**
     * 通过当前id(currentFragmentId)获取当前的Fragment
     *
     * @return 当前Fragment或是null
     */
    public Fragment getCurrentFragment() {
        if (currentFragmentId >= 0) {
            return getFragment(currentFragmentId);
        }
        return null;
    }

    //    /**
    //     * 在super.onActivityResult后调用<br>
    //     * 会调用当前Fragment中的onActivityResult
    //     */
    //    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    //        if (getCurrentFragment() != null)
    //            getCurrentFragment().onActivityResult(requestCode, resultCode, data);
    //    }

}
