package cayte.frame.ui.v4;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;

import cayte.frame.manager.IsRefreshManager;
import cayte.frame.task.GenericTask;
import cayte.frame.task.TaskManager;

public class UIV4Fragment<T extends Fragment, E extends UIV4FragmentInterface> {

    /**
     * LayoutInflater
     */
    public LayoutInflater inflater = null;
    /**
     * UI需要实现的相关接口
     */
    public E ai;
    /**
     * 可调用到所在Activity的onFragment(int type, Object... params)
     */
    public UIV4TabInterface onFragmentListener = null;
    /**
     * T extends Fragment
     */
    protected T a;
    /**
     * Task管理
     */
    protected TaskManager taskManager = null;

    /**
     * 实例化
     *
     * @param a  a extends Fragment
     * @param ai ai implements UIInterface
     */
    public UIV4Fragment(T a, E ai) {
        this.a = a;
        this.ai = ai;
        this.onFragmentListener = (UIV4TabInterface) a.getActivity();
    }

    /**
     * 获取Fragment所在的Activity实例
     *
     * @return TabActivity
     */
    public Activity getA() {
        return a.getActivity();
    }

    /**
     * 获取 T extends Fragment 实例
     *
     * @return T extends Fragment
     */
    public T getF() {
        return a;
    }

    /**
     * 在super.onCreate后调用<br>
     * 初始化taskManager,inflater
     */
    public void onCreate() {
        taskManager = new TaskManager();
        inflater = (LayoutInflater) a.getActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    /**
     * 在super.onResume后调用<br>
     * ai.refresh(IsRefreshManager.instance().get(a.getClass()));
     */
    public void onResume() {
        ai.refresh(IsRefreshManager.instance().get(a.getClass()));
    }

    /**
     * 在super.onDestroy后调用<br>
     * 取消所有Task<br>
     * 销毁对象taskManager,inflater
     */
    public void onDestroy() {
        cancelAllTask();
        taskManager.deleteObservers();
        taskManager = null;
        inflater = null;
    }

    /**
     * 在super.onHiddenChanged后调用<br>
     *
     * @param hidden 传入onHiddenChanged参数
     */
    public void onHiddenChanged(boolean hidden) {
        if (hidden) {
            // 出界面
            ai.onHideFragment();
        } else {
            // 进界面
            ai.refresh(IsRefreshManager.instance().get(a.getClass()));
            ai.onShowFragment();
        }
    }


    /**
     * 集合设置是否可见,setVisibility
     *
     * @param visible like View.VISIBLE
     * @param views   View...
     */
    public void setVisibility(int visible, View... views) {
        for (View v : views) {
            v.setVisibility(visible);
        }
    }

    /**
     * 集合设置点击事件,setOnClickListener
     *
     * @param click 点击事件View.OnClickListener
     * @param views View...
     */
    public void setClickListener(View.OnClickListener click, View... views) {
        for (View v : views) {
            v.setOnClickListener(click);
        }
    }

    /**
     * 执行线程并加入到TaskManager中
     *
     * @param genericTask GenericTask
     */
    public void execute(GenericTask<?> genericTask) {
        if (genericTask.getStatus() != android.os.AsyncTask.Status.PENDING)
            return;
        genericTask.execute();
        taskManager.addTask(genericTask);
    }

    /**
     * 执行线程并加入到TaskManager中
     *
     * @param genericTask GenericTask
     * @param params      参数集合
     * @param <T>         参数泛型
     */
    public <T> void execute(GenericTask<T> genericTask, T... params) {
        if (genericTask.getStatus() != android.os.AsyncTask.Status.PENDING)
            return;
        genericTask.execute(params);
        taskManager.addTask(genericTask);
    }

    /**
     * 取消TaskManager中所有线程(只能取消回调,不能中断线程)
     */
    public void cancelAllTask() {
        taskManager.cancelAll();
    }

}
