package cayte.frame.manager;

import java.util.HashMap;
import java.util.Map;

public class IsRefreshManager {
    private static IsRefreshManager isRefreshManager;

    private Map<String, String> map;

    public IsRefreshManager() {
        map = new HashMap<String, String>();
    }

    public static IsRefreshManager instance() {
        if (isRefreshManager == null) {
            synchronized (IsRefreshManager.class) {
                if (isRefreshManager == null)
                    isRefreshManager = new IsRefreshManager();
            }
        }
        return isRefreshManager;
    }

    public String get(Class<?> cls) {
        String simpleName = new String(cls.getCanonicalName());
        cls = null;
        String action = map.get(simpleName);
        if (action == null)
            return "";
        map.remove(simpleName);
        return action;
    }

    public void put(Class<?> cls, String action) {
        String simpleName = new String(cls.getCanonicalName());
        cls = null;
        map.put(simpleName, action);
    }

    public void put(String SimpleName, String action) {
        map.put(SimpleName, action);
    }

}
