package cayte.frame.log;

import android.annotation.SuppressLint;
import android.os.Environment;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

import cayte.frame.file.F;

@SuppressLint("SimpleDateFormat")
public class L {

    private static String LOG_DIR = null;
    private static int CLEAR_DAYS = 7;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static String logName;

    public static void logDir(String logDir) {
        L.LOG_DIR = logDir;
    }

    public static void logName(String logName) {
        L.logName = logName;
    }

    public static String getLogName() {
        if (logName == null || logName.equals(""))
            logName = "log";
        return logName;
    }

    public static void clearDays(int days) {
        L.CLEAR_DAYS = days;
    }

    private static String getLogPath() {
        if (LOG_DIR == null)
            LOG_DIR = F.getCache("log");
        String name = getLogName() + "_" + new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis())) + ".txt";
        return LOG_DIR + name;
    }

    private static String getTimeString() {
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    public static void log(String name, String tag, String log) {
        doLog(getTimeString() + "\t" + name + "\t" + tag + "\t" + log);
    }

    public static void log(String name, String tag, String log, Throwable tr) {
        logMulti(name, tag, log + "\n" + getErrorInfo(tr));
    }

    public static void logMulti(String name, String tag, String log) {
        String[] logs = log.split("\n");
        for (String l : logs) {
            if (l != null && !l.equals(""))
                log(name, tag, l);
        }
    }

    public static void doLog(String log) {
        FileWriter filerWriter = null;
        BufferedWriter bufWriter = null;
        try {
            boolean sdCardExist = Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED);
            if (!sdCardExist)
                return;

            File logFile = new File(getLogPath());
            if (!logFile.exists())
                logFile.createNewFile();
            filerWriter = new FileWriter(logFile, true);
            bufWriter = new BufferedWriter(filerWriter);
            bufWriter.write(log);
            bufWriter.newLine();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                bufWriter.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
            try {
                filerWriter.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getErrorInfo(Throwable tr) {
        Writer writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        tr.printStackTrace(pw);
        pw.close();
        String error = writer.toString().trim();
        return error;
    }

    public static void clear() {
        long day = 24l * 3600l * 1000l;
        long time = System.currentTimeMillis();
        for (int i = 0; i < CLEAR_DAYS; i++) {
            clearDay(time - day * i);
        }
    }

    public static void clearDay(long timeMillis) {
        String today = new SimpleDateFormat("yyyy-MM-dd").format(timeMillis) + ".txt";
        File dir = new File(LOG_DIR);
        dir.mkdirs();
        File[] list = dir.listFiles();
        if (list != null)
            for (File file : list) {
                if (!file.getName().endsWith(today))
                    file.delete();
            }
    }

    public static String getLogDir() {
        return LOG_DIR;
    }

}
