package cayte.frame.helper;

import android.app.Activity;
import android.util.DisplayMetrics;

/**
 * 
 * 系统参数类
 * 
 * @author Cayte
 * 
 */
public class MobileParams {
	private final String TAG = "SystemParams";
	private static MobileParams params;
	public static int SCREEN_WIDTH = 0;// 屏幕宽度，单位为px
	public static int SCREEN_HEIGHT = 0;// 屏幕高度，单位为px
	public int densityDpi;// 屏幕密度，单位为dpi
	public float scale;// 缩放系数，值为 densityDpi/160
	public float fontScale;// 文字缩放系数，同scale

	public final static int SCREEN_ORIENTATION_VERTICAL = 1; // 屏幕状态：横屏
	public final static int SCREEN_ORIENTATION_HORIZONTAL = 2; // 屏幕状态：竖屏
	public int screenOrientation = SCREEN_ORIENTATION_VERTICAL;// 当前屏幕状态，默认为竖屏

	private MobileParams(Activity activity) {
		DisplayMetrics dm = new DisplayMetrics();
		activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
		activity = null;
		SCREEN_WIDTH = dm.widthPixels;
		SCREEN_HEIGHT = dm.heightPixels;
		densityDpi = dm.densityDpi;
		scale = dm.density;
		fontScale = dm.scaledDensity;
		screenOrientation = SCREEN_HEIGHT > SCREEN_WIDTH ? SCREEN_ORIENTATION_VERTICAL : SCREEN_ORIENTATION_HORIZONTAL;
	}


	public static MobileParams instance(Activity activity) {
		if (params == null) {
			synchronized (MobileParams.class) {
				if (params == null)
					params = new MobileParams(activity);
			}
		}
		return params;
	}

	public static MobileParams instance() {
		return params;
	}

	public static MobileParams newInstance(Activity activity) {
		if (params != null) {
			synchronized (MobileParams.class) {
				if (params != null)
					params = null;
			}
		}
		return instance(activity);
	}

	public String toString() {

		return TAG + ":[screenWidth: " + SCREEN_WIDTH + " screenHeight: " + SCREEN_HEIGHT + " scale: " + scale
				+ " fontScale: " + fontScale + " densityDpi: " + densityDpi + " screenOrientation: "
				+ (screenOrientation == SCREEN_ORIENTATION_VERTICAL ? "vertical" : "horizontal") + "]";
	}

}
