package cayte.frame.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * 
 * 文件夹操作helper类
 * 
 * @author Cayte
 * 
 */
public class FolderUtils {

	public static void createFolder(String... paths) {
		for (String path : paths) {
			checkFolder(path);
		}
	}

	public static boolean checkFolder(String path) {
		try {
			File dir = new File(path);
			if (dir.exists()) {
				if (dir.isDirectory()) {
					return true;
				} else {
					dir.delete();
					return checkFolder(path);
				}
			} else {
				if (checkFolder(dir.getParent()))
					return dir.mkdir();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	public static void deleteFile(String path) {
		try {
			// 判空, 保证路径是有效的
			if (path != null && !path.equals("")) {
				File file = new File(path);
				// 判断文件是否存在
				if (file.exists()) {
					// 如果是目录则递归计算其文件个数，如果是文件则直接返回1
					if (file.isFile()) {
						file.delete();
					} else {
						// 获取文件大小
						File[] fl = file.listFiles();
						if (fl != null && fl.length > 0) {
							for (File f : fl) {
								deleteFile(f.getAbsolutePath());
							}
						}
						if (file != null) {
							file.delete();
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void deleteFile(String path, String... outPath) {
		try {
			List<String> outs = new ArrayList<String>();
			if (outPath != null)
				for (int i = 0; i < outPath.length; i++) {
					outs.add(outPath[i]);
				}
			// 判空, 保证路径是有效的
			if (path != null && !path.equals("")) {
				File file = new File(path);
				// 判断文件是否存在
				if (file.exists()) {
					if (!outs.contains(file.getAbsolutePath())) {
						// 如果是目录则递归计算其文件个数，如果是文件则直接返回1
						if (file.isFile()) {
							file.delete();
						} else {
							// 获取文件大小
							File[] fl = file.listFiles();
							if (fl != null && fl.length > 0) {
								for (File f : fl) {
									deleteFile(f.getAbsolutePath(), outPath);
								}
							}
							if (file != null) {
								file.delete();
							}
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void copyFile(String fromPath, String toPath) {
		try {
			// 判空, 保证路径是有效的
			if (fromPath != null && !fromPath.equals("") && toPath != null && !toPath.equals("")) {
				File from = new File(fromPath);
				File to = new File(toPath);
				// 判断文件是否存在
				if (from.exists()) {
					if (from.isFile()) {
						FileUtils.fileChannelCopy(from, to);
					} else if (from.isDirectory()) {
						to.mkdirs();
						// 获取文件大小
						File[] fl = from.listFiles();
						if (fl != null && fl.length > 0) {
							for (File f : fl) {
								copyFile(f.getPath(), toPath + File.separator + f.getName());
							}
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
