package cayte.frame.encrypt;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import android.annotation.SuppressLint;
import android.util.Base64;

public class DES {

	public static String encrypt(String key, byte[] iv, String data) throws Exception {
		byte[] result = encrypt(key, iv, data.getBytes());
		return new String(Base64.encode(result, Base64.NO_WRAP));
	}

	@SuppressLint("TrulyRandom")
	private static byte[] encrypt(String key, byte[] iv, byte[] data) throws Exception {
		IvParameterSpec ivSpec = new IvParameterSpec(iv);
		DESKeySpec dks = new DESKeySpec(key.getBytes());
		SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
		SecretKey secretKey = keyFactory.generateSecret(dks);
		Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
		cipher.init(Cipher.ENCRYPT_MODE, secretKey, ivSpec);
		return cipher.doFinal(data);
	}

	public static String decrypt(String key, byte[] iv, String data) throws Exception {
		byte[] decryResult = decrypt(key, iv, Base64.decode(data, Base64.NO_WRAP));
		return new String(decryResult);
	}

	private static byte[] decrypt(String key, byte[] iv, byte[] src) throws Exception {
		IvParameterSpec ivSpec = new IvParameterSpec(iv);
		SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "DES");
		Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
		cipher.init(Cipher.DECRYPT_MODE, keySpec, ivSpec);
		return cipher.doFinal(src);
	}

}