package cayte.frame.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

import android.os.Bundle;

import cayte.frame.log.D;

public class DataPool {
    public static final String TAG = DataPool.class.getCanonicalName();

    private static final boolean DEFAULT_LIMIT = false;

    private static DataPool dataPool = null;
    private static HashMap<String, Boolean> limits = null;

    private static Bundle cache = null;

    public DataPool() {
        limits = new HashMap<String, Boolean>();
        cache = new Bundle();
    }

    public static DataPool instance() {
        if (dataPool == null) {
            synchronized (DataPool.class) {
                if (dataPool == null)
                    dataPool = new DataPool();
            }
        }
        return dataPool;
    }

    public void remove(String key) {
        limits.remove(key);
        cache.remove(key);
    }

    private void checkLimit(String key) {
        boolean limit = limits.get(key) == null ? false : limits.get(key);
        if (limit) {
            limits.remove(key);
            cache.remove(key);
        }
    }

    public void clear() {
        limits.clear();
        cache.clear();
    }

    public void put(String key, BaseObject obj) {
        put(key, obj, DEFAULT_LIMIT);
    }

    public void put(String key, BaseObject obj, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putSerializable(key, obj);
        limits.put(key, limit);
    }

    public BaseObject getBaseObj(String key) {
        if (key == null)
            return null;
        Object obj = null;
        obj = cache.getSerializable(key);
        if (obj == null) {
            D.e(TAG, "getBaseObj --> the value is null.");
            return null;
        }
        checkLimit(key);
        return (BaseObject) obj;
    }


    public void put(String key, List<?> objList) {
        put(key, objList, DEFAULT_LIMIT);
    }

    public void put(String key, List<?> objList, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putSerializable(key, (Serializable) objList);
        limits.put(key, limit);
    }

    @SuppressWarnings("unchecked")
    public <T> List<T> getListBaseObj(String key) {
        if (key == null)
            return null;
        Object obj = null;
        obj = cache.getSerializable(key);
        if (obj == null) {
            D.e(TAG, "getArrayBaseObj --> the value is null.");
            return null;
        }
        checkLimit(key);
        return (List<T>) obj;
    }


    public void put(String key, int integer) {
        put(key, integer, DEFAULT_LIMIT);
    }

    public void put(String key, int integer, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putInt(key, integer);
        limits.put(key, limit);
    }

    public int getInteger(String key) {
        if (key == null)
            return 0;
        int integer = cache.getInt(key);
        checkLimit(key);
        return integer;
    }


    public void put(String key, int[] integerArray) {
        put(key, integerArray, DEFAULT_LIMIT);
    }

    public void put(String key, int[] integerArray, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putIntArray(key, integerArray);
        limits.put(key, limit);
    }

    public int[] getArrayInteger(String key) {
        if (key == null)
            return null;
        int[] integerArray = cache.getIntArray(key);
        if (integerArray == null) {
            D.e(TAG, "getArrayInteger --> the value is null.");
            return null;
        }
        checkLimit(key);
        return integerArray;
    }


    public void put(String key, String string) {
        put(key, string, DEFAULT_LIMIT);
    }

    public void put(String key, String string, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putString(key, string);
        limits.put(key, limit);
    }

    public String getString(String key) {
        if (key == null)
            return null;
        String string = cache.getString(key);
        if (string == null) {
            D.e(TAG, "getString --> the value is null.");
            return null;
        }
        checkLimit(key);
        return string;
    }

    public void put(String key, String[] stringArray) {
        put(key, stringArray, DEFAULT_LIMIT);
    }

    public void put(String key, String[] stringArray, boolean limit) {
        if (cache.containsKey(key)) {
            D.i(TAG, "the key of put already exists,key is " + key);
        }
        cache.putStringArray(key, stringArray);
        limits.put(key, limit);
    }

    public String[] getArrayString(String key) {
        if (key == null)
            return null;
        String[] stringArray = cache.getStringArray(key);
        if (stringArray == null) {
            D.e(TAG, "getArrayString --> the value is null.");
            return null;
        }
        checkLimit(key);
        return stringArray;
    }

}
