package cayte.frame.data;

import java.io.Serializable;
import java.lang.reflect.Method;

import cayte.frame.log.D;

public abstract class BaseObject implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static final String TAG = BaseObject.class.getCanonicalName();

	private Method method = null;

	public String getValue(String methodName) {
		try {
			method = this.getClass().getDeclaredMethod(methodName);
			return method.invoke(this).toString();
		} catch (Exception e) {
			D.e(TAG, "getValue error:" + e.getMessage());
		}
		return "";
	}

	@SuppressWarnings("unchecked")
	public <T> T toObj() {
		return (T) this;
	}
}
