package cayte.frame.adapter;

import android.app.Activity;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.List;

import cayte.frame.task.GenericTask;
import cayte.frame.ui.UIInterface;

public abstract class RecycleViewAdapter<T, E extends RecycleViewHolder> extends RecyclerView.Adapter {

    protected List<T> datas;
    protected Activity act = null;
    protected LayoutInflater inflater = null;

    public RecycleViewAdapter(Activity act) {
        datas = new ArrayList<T>();
        this.act = act;
        inflater = LayoutInflater.from(act);
    }

    public RecycleViewAdapter(LayoutInflater inflater) {
        datas = new ArrayList<T>();
        this.inflater = inflater;
    }

    protected abstract int getLayoutResourceId(int viewType);

    protected abstract E createViewHolder(View view, int viewType);

    protected abstract void _onCreateViewHolder(E viewHolder, int viewType);

    protected abstract void _onBindViewHolder(E viewHolder, T data, int position);

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(getLayoutResourceId(viewType), parent, false);
        E viewHolder = createViewHolder(view, viewType);
        _onCreateViewHolder(viewHolder, viewType);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        E viewHolder = (E) holder;
        viewHolder.setPostion(position);
        _onBindViewHolder(viewHolder, getItem(position), position);
    }

    public List<T> getDatas() {
        return datas;
    }

    public void setDatas(List<T> datas) {
        if (datas == null)
            return;
        this.datas = datas;
    }

    public void clear() {
        this.datas.clear();
    }


    @Override
    public int getItemCount() {
        return datas == null ? 0 : datas.size();
    }

    public T getItem(int position) {
        return datas.get(position);
    }

    public boolean isEmpty() {
        return getItemCount() == 0;
    }

    public T getFirstItem() {
        if (isEmpty())
            return null;
        return datas.get(0);
    }

    public T getLastItem() {
        if (isEmpty())
            return null;
        return datas.get(datas.size() - 1);
    }

    @SuppressWarnings("hiding")
    public <T> void execute(GenericTask<T> genericTask) {
        if (act != null && act instanceof UIInterface) {
            ((UIInterface) act).getUIActivity().execute(genericTask);
        } else {
            genericTask.execute();
        }
    }

    @SuppressWarnings("hiding")
    public <T> void execute(GenericTask<T> genericTask, T... params) {
        if (act != null && act instanceof UIInterface) {
            ((UIInterface) act).getUIActivity().execute(genericTask, params);
        } else {
            genericTask.execute(params);
        }
    }

    public void cancelAllTask() {
        if (act != null && act instanceof UIInterface) {
            ((UIInterface) act).getUIActivity().cancelAllTask();
        }
    }


}
