package cayte.frame.adapter;

import android.view.View;

public abstract class OnItemLongClick implements View.OnLongClickListener {

    protected int position = -1;

    public OnItemLongClick(int position) {
        this.position = position;
    }

    @Override
    public boolean onLongClick(View v) {
        if (position < 0)
            return false;
        return _onLongClick(v, position);
    }

    public abstract boolean _onLongClick(View v, int position);

}