package cayte.frame.adapter;

import android.view.View;

public abstract class OnItemChildClick implements View.OnClickListener {

    protected int groupPosition = -1;
    protected int childPosition = -1;

    public OnItemChildClick(int groupPosition, int childPosition) {
        this.groupPosition = groupPosition;
        this.childPosition = childPosition;
    }

    @Override
    public void onClick(View v) {
        if (groupPosition < 0 || childPosition < 0)
            return;
        _onChildClick(v, groupPosition, childPosition);
    }

    public abstract void _onChildClick(View v, int groupPosition, int childPosition);

}