package cayte.frame.adapter;

import android.app.Activity;
import android.view.LayoutInflater;
import android.widget.BaseAdapter;

import java.util.ArrayList;
import java.util.List;

import cayte.frame.task.GenericTask;
import cayte.frame.ui.UIInterface;

public abstract class ListAdapter<T> extends BaseAdapter {

    protected List<T> datas;
    protected Activity act = null;
    protected LayoutInflater inflater = null;

    public ListAdapter(Activity act) {
        datas = new ArrayList<T>();
        this.act = act;
        inflater = LayoutInflater.from(act);
    }

    public ListAdapter(LayoutInflater inflater) {
        datas = new ArrayList<T>();
        this.inflater = inflater;
    }

    public List<T> getDatas() {
        return datas;
    }

    public void setDatas(List<T> datas) {
        if (datas == null)
            return;
        this.datas = datas;
        notifyDataSetChanged();
    }

    public void clear() {
        this.datas.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getCount() {
        return datas == null ? 0 : datas.size();
    }

    @Override
    public T getItem(int position) {
        return datas.get(position);
    }

    public T getFirstItem() {
        if (isEmpty())
            return null;
        return datas.get(0);
    }

    public T getLastItem() {
        if (isEmpty())
            return null;
        return datas.get(datas.size() - 1);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @SuppressWarnings("hiding")
    public <T> void execute(GenericTask<T> genericTask) {
        if (act != null && act instanceof UIInterface) {
            ((UIInterface) act).getUIActivity().execute(genericTask);
        } else {
            genericTask.execute();
        }
    }

    @SuppressWarnings("hiding")
    public <T> void execute(GenericTask<T> genericTask, T... params) {
        if (act != null && act instanceof UIInterface) {
            ((UIInterface) act).getUIActivity().execute(genericTask, params);
        } else {
            genericTask.execute(params);
        }
    }

    public void cancelAllTask() {
        if (act != null && act instanceof UIInterface) {
            ((UIInterface) act).getUIActivity().cancelAllTask();
        }
    }

}
