/*
 * Decompiled with CFR 0.152.
 */
package cat.ereza.customactivityoncrash.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.res.ResourcesCompat;
import cat.ereza.customactivityoncrash.CustomActivityOnCrash;
import cat.ereza.customactivityoncrash.R;
import cat.ereza.customactivityoncrash.config.CaocConfig;

public final class DefaultErrorActivity
extends AppCompatActivity {
    @SuppressLint(value={"PrivateResource"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TypedArray a = this.obtainStyledAttributes(R.styleable.AppCompatTheme);
        if (!a.hasValue(R.styleable.AppCompatTheme_windowActionBar)) {
            this.setTheme(R.style.Theme_AppCompat_Light_DarkActionBar);
        }
        a.recycle();
        this.setContentView(R.layout.customactivityoncrash_default_error_activity);
        Button restartButton = (Button)this.findViewById(R.id.customactivityoncrash_error_activity_restart_button);
        final CaocConfig config = CustomActivityOnCrash.getConfigFromIntent(this.getIntent());
        if (config == null) {
            this.finish();
            return;
        }
        if (config.isShowRestartButton() && config.getRestartActivityClass() != null) {
            restartButton.setText(R.string.customactivityoncrash_error_activity_restart_app);
            restartButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CustomActivityOnCrash.restartApplication((Activity)DefaultErrorActivity.this, config);
                }
            });
        } else {
            restartButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CustomActivityOnCrash.closeApplication((Activity)DefaultErrorActivity.this, config);
                }
            });
        }
        Button moreInfoButton = (Button)this.findViewById(R.id.customactivityoncrash_error_activity_more_info_button);
        if (config.isShowErrorDetails()) {
            moreInfoButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AlertDialog dialog = new AlertDialog.Builder((Context)DefaultErrorActivity.this).setTitle(R.string.customactivityoncrash_error_activity_error_details_title).setMessage((CharSequence)CustomActivityOnCrash.getAllErrorDetailsFromIntent((Context)DefaultErrorActivity.this, DefaultErrorActivity.this.getIntent())).setPositiveButton(R.string.customactivityoncrash_error_activity_error_details_close, null).setNeutralButton(R.string.customactivityoncrash_error_activity_error_details_copy, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            DefaultErrorActivity.this.copyErrorToClipboard();
                        }
                    }).show();
                    TextView textView = (TextView)dialog.findViewById(16908299);
                    if (textView != null) {
                        textView.setTextSize(0, DefaultErrorActivity.this.getResources().getDimension(R.dimen.customactivityoncrash_error_activity_error_details_text_size));
                    }
                }
            });
        } else {
            moreInfoButton.setVisibility(8);
        }
        Integer defaultErrorActivityDrawableId = config.getErrorDrawable();
        ImageView errorImageView = (ImageView)this.findViewById(R.id.customactivityoncrash_error_activity_image);
        if (defaultErrorActivityDrawableId != null) {
            errorImageView.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)defaultErrorActivityDrawableId, (Resources.Theme)this.getTheme()));
        }
    }

    private void copyErrorToClipboard() {
        String errorInformation = CustomActivityOnCrash.getAllErrorDetailsFromIntent((Context)this, this.getIntent());
        ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
        if (clipboard != null) {
            ClipData clip = ClipData.newPlainText((CharSequence)this.getString(R.string.customactivityoncrash_error_activity_error_details_clipboard_label), (CharSequence)errorInformation);
            clipboard.setPrimaryClip(clip);
            Toast.makeText((Context)this, (int)R.string.customactivityoncrash_error_activity_error_details_copied, (int)0).show();
        }
    }
}

