/*
 * Decompiled with CFR 0.152.
 */
package cat.ereza.customactivityoncrash;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.util.Log;
import cat.ereza.customactivityoncrash.activity.DefaultErrorActivity;
import cat.ereza.customactivityoncrash.config.CaocConfig;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class CustomActivityOnCrash {
    private static final String TAG = "CustomActivityOnCrash";
    private static final String EXTRA_CONFIG = "cat.ereza.customactivityoncrash.EXTRA_CONFIG";
    private static final String EXTRA_STACK_TRACE = "cat.ereza.customactivityoncrash.EXTRA_STACK_TRACE";
    private static final String EXTRA_ACTIVITY_LOG = "cat.ereza.customactivityoncrash.EXTRA_ACTIVITY_LOG";
    private static final String INTENT_ACTION_ERROR_ACTIVITY = "cat.ereza.customactivityoncrash.ERROR";
    private static final String INTENT_ACTION_RESTART_ACTIVITY = "cat.ereza.customactivityoncrash.RESTART";
    private static final String CAOC_HANDLER_PACKAGE_NAME = "cat.ereza.customactivityoncrash";
    private static final String DEFAULT_HANDLER_PACKAGE_NAME = "com.android.internal.os";
    private static final int MAX_STACK_TRACE_SIZE = 131071;
    private static final int MAX_ACTIVITIES_IN_LOG = 50;
    private static final String SHARED_PREFERENCES_FILE = "custom_activity_on_crash";
    private static final String SHARED_PREFERENCES_FIELD_TIMESTAMP = "last_crash_timestamp";
    @SuppressLint(value={"StaticFieldLeak"})
    private static Application application;
    private static CaocConfig config;
    private static final Deque<String> activityLog;
    private static WeakReference<Activity> lastActivityCreated;
    private static boolean isInBackground;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void install(@Nullable Context context) {
        try {
            if (context == null) {
                Log.e((String)TAG, (String)"Install failed: context is null!");
            } else {
                final Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
                if (oldHandler != null && oldHandler.getClass().getName().startsWith(CAOC_HANDLER_PACKAGE_NAME)) {
                    Log.e((String)TAG, (String)"CustomActivityOnCrash was already installed, doing nothing!");
                } else {
                    if (oldHandler != null && !oldHandler.getClass().getName().startsWith(DEFAULT_HANDLER_PACKAGE_NAME)) {
                        Log.e((String)TAG, (String)"IMPORTANT WARNING! You already have an UncaughtExceptionHandler, are you sure this is correct? If you use a custom UncaughtExceptionHandler, you must initialize it AFTER CustomActivityOnCrash! Installing anyway, but your original handler will not be called.");
                    }
                    application = (Application)context.getApplicationContext();
                    Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread thread, Throwable throwable) {
                            if (config.isEnabled()) {
                                Activity lastActivity;
                                Log.e((String)CustomActivityOnCrash.TAG, (String)"App has crashed, executing CustomActivityOnCrash's UncaughtExceptionHandler", (Throwable)throwable);
                                if (CustomActivityOnCrash.hasCrashedInTheLastSeconds((Context)application)) {
                                    Log.e((String)CustomActivityOnCrash.TAG, (String)"App already crashed recently, not starting custom error activity because we could enter a restart loop. Are you sure that your app does not crash directly on init?", (Throwable)throwable);
                                    if (oldHandler != null) {
                                        oldHandler.uncaughtException(thread, throwable);
                                        return;
                                    }
                                } else {
                                    CustomActivityOnCrash.setLastCrashTimestamp((Context)application, new Date().getTime());
                                    Class errorActivityClass = config.getErrorActivityClass();
                                    if (errorActivityClass == null) {
                                        errorActivityClass = CustomActivityOnCrash.guessErrorActivityClass((Context)application);
                                    }
                                    if (CustomActivityOnCrash.isStackTraceLikelyConflictive(throwable, errorActivityClass)) {
                                        Log.e((String)CustomActivityOnCrash.TAG, (String)"Your application class or your error activity have crashed, the custom activity will not be launched!");
                                        if (oldHandler != null) {
                                            oldHandler.uncaughtException(thread, throwable);
                                            return;
                                        }
                                    } else if (config.getBackgroundMode() == 1 || !isInBackground) {
                                        Intent intent = new Intent((Context)application, errorActivityClass);
                                        StringWriter sw = new StringWriter();
                                        PrintWriter pw = new PrintWriter(sw);
                                        throwable.printStackTrace(pw);
                                        String stackTraceString = sw.toString();
                                        if (stackTraceString.length() > 131071) {
                                            String disclaimer = " [stack trace too large]";
                                            stackTraceString = stackTraceString.substring(0, 131071 - disclaimer.length()) + disclaimer;
                                        }
                                        intent.putExtra(CustomActivityOnCrash.EXTRA_STACK_TRACE, stackTraceString);
                                        if (config.isTrackActivities()) {
                                            StringBuilder activityLogStringBuilder = new StringBuilder();
                                            while (!activityLog.isEmpty()) {
                                                activityLogStringBuilder.append((String)activityLog.poll());
                                            }
                                            intent.putExtra(CustomActivityOnCrash.EXTRA_ACTIVITY_LOG, activityLogStringBuilder.toString());
                                        }
                                        if (config.isShowRestartButton() && config.getRestartActivityClass() == null) {
                                            config.setRestartActivityClass(CustomActivityOnCrash.guessRestartActivityClass((Context)application));
                                        }
                                        intent.putExtra(CustomActivityOnCrash.EXTRA_CONFIG, (Serializable)config);
                                        intent.setFlags(0x10008000);
                                        if (config.getEventListener() != null) {
                                            config.getEventListener().onLaunchErrorActivity();
                                        }
                                        application.startActivity(intent);
                                    } else if (config.getBackgroundMode() == 2 && oldHandler != null) {
                                        oldHandler.uncaughtException(thread, throwable);
                                        return;
                                    }
                                }
                                if ((lastActivity = (Activity)lastActivityCreated.get()) != null) {
                                    lastActivity.finish();
                                    lastActivityCreated.clear();
                                }
                                CustomActivityOnCrash.killCurrentProcess();
                            } else if (oldHandler != null) {
                                oldHandler.uncaughtException(thread, throwable);
                            }
                        }
                    });
                    application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){
                        int currentlyStartedActivities = 0;
                        final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);

                        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                            if (activity.getClass() != config.getErrorActivityClass()) {
                                lastActivityCreated = new WeakReference<Activity>(activity);
                            }
                            if (config.isTrackActivities()) {
                                activityLog.add(this.dateFormat.format(new Date()) + ": " + activity.getClass().getSimpleName() + " created\n");
                            }
                        }

                        public void onActivityStarted(Activity activity) {
                            ++this.currentlyStartedActivities;
                            isInBackground = this.currentlyStartedActivities == 0;
                        }

                        public void onActivityResumed(Activity activity) {
                            if (config.isTrackActivities()) {
                                activityLog.add(this.dateFormat.format(new Date()) + ": " + activity.getClass().getSimpleName() + " resumed\n");
                            }
                        }

                        public void onActivityPaused(Activity activity) {
                            if (config.isTrackActivities()) {
                                activityLog.add(this.dateFormat.format(new Date()) + ": " + activity.getClass().getSimpleName() + " paused\n");
                            }
                        }

                        public void onActivityStopped(Activity activity) {
                            --this.currentlyStartedActivities;
                            isInBackground = this.currentlyStartedActivities == 0;
                        }

                        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                        }

                        public void onActivityDestroyed(Activity activity) {
                            if (config.isTrackActivities()) {
                                activityLog.add(this.dateFormat.format(new Date()) + ": " + activity.getClass().getSimpleName() + " destroyed\n");
                            }
                        }
                    });
                }
                Log.i((String)TAG, (String)"CustomActivityOnCrash has been installed.");
            }
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"An unknown error occurred while installing CustomActivityOnCrash, it may not have been properly initialized. Please report this as a bug if needed.", (Throwable)t);
        }
    }

    @Nullable
    public static String getStackTraceFromIntent(@NonNull Intent intent) {
        return intent.getStringExtra(EXTRA_STACK_TRACE);
    }

    @Nullable
    public static CaocConfig getConfigFromIntent(@NonNull Intent intent) {
        String stackTrace;
        CaocConfig config = (CaocConfig)intent.getSerializableExtra(EXTRA_CONFIG);
        if (config.isLogErrorOnRestart() && (stackTrace = CustomActivityOnCrash.getStackTraceFromIntent(intent)) != null) {
            Log.e((String)TAG, (String)("The previous app process crashed. This is the stack trace of the crash:\n" + CustomActivityOnCrash.getStackTraceFromIntent(intent)));
        }
        return config;
    }

    @Nullable
    public static String getActivityLogFromIntent(@NonNull Intent intent) {
        return intent.getStringExtra(EXTRA_ACTIVITY_LOG);
    }

    @NonNull
    public static String getAllErrorDetailsFromIntent(@NonNull Context context, @NonNull Intent intent) {
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String buildDateAsString = CustomActivityOnCrash.getBuildDateAsString(context, dateFormat);
        String versionName = CustomActivityOnCrash.getVersionName(context);
        String errorDetails = "";
        errorDetails = errorDetails + "Build version: " + versionName + " \n";
        if (buildDateAsString != null) {
            errorDetails = errorDetails + "Build date: " + buildDateAsString + " \n";
        }
        errorDetails = errorDetails + "Current date: " + dateFormat.format(currentDate) + " \n";
        errorDetails = errorDetails + "Device: " + CustomActivityOnCrash.getDeviceModelName() + " \n \n";
        errorDetails = errorDetails + "Stack trace:  \n";
        errorDetails = errorDetails + CustomActivityOnCrash.getStackTraceFromIntent(intent);
        String activityLog = CustomActivityOnCrash.getActivityLogFromIntent(intent);
        if (activityLog != null) {
            errorDetails = errorDetails + "\nUser actions: \n";
            errorDetails = errorDetails + activityLog;
        }
        return errorDetails;
    }

    public static void restartApplicationWithIntent(@NonNull Activity activity, @NonNull Intent intent, @NonNull CaocConfig config) {
        intent.addFlags(270565376);
        if (intent.getComponent() != null) {
            intent.setAction("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.LAUNCHER");
        }
        if (config.getEventListener() != null) {
            config.getEventListener().onRestartAppFromErrorActivity();
        }
        activity.finish();
        activity.startActivity(intent);
        CustomActivityOnCrash.killCurrentProcess();
    }

    public static void restartApplication(@NonNull Activity activity, @NonNull CaocConfig config) {
        Intent intent = new Intent((Context)activity, config.getRestartActivityClass());
        CustomActivityOnCrash.restartApplicationWithIntent(activity, intent, config);
    }

    public static void closeApplication(@NonNull Activity activity, @NonNull CaocConfig config) {
        if (config.getEventListener() != null) {
            config.getEventListener().onCloseAppFromErrorActivity();
        }
        activity.finish();
        CustomActivityOnCrash.killCurrentProcess();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public static CaocConfig getConfig() {
        return config;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void setConfig(@NonNull CaocConfig config) {
        CustomActivityOnCrash.config = config;
    }

    private static boolean isStackTraceLikelyConflictive(@NonNull Throwable throwable, @NonNull Class<? extends Activity> activityClass) {
        do {
            StackTraceElement[] stackTrace;
            for (StackTraceElement element : stackTrace = throwable.getStackTrace()) {
                if ((!element.getClassName().equals("android.app.ActivityThread") || !element.getMethodName().equals("handleBindApplication")) && !element.getClassName().equals(activityClass.getName())) continue;
                return true;
            }
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    @Nullable
    private static String getBuildDateAsString(@NonNull Context context, @NonNull DateFormat dateFormat) {
        long buildDate;
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            ZipFile zf = new ZipFile(ai.sourceDir);
            ZipEntry ze = zf.getEntry("classes.dex");
            buildDate = ze.getTime();
            zf.close();
        }
        catch (Exception e) {
            buildDate = 0L;
        }
        if (buildDate > 312764400000L) {
            return dateFormat.format(new Date(buildDate));
        }
        return null;
    }

    @NonNull
    private static String getVersionName(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    @NonNull
    private static String getDeviceModelName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return CustomActivityOnCrash.capitalize(model);
        }
        return CustomActivityOnCrash.capitalize(manufacturer) + " " + model;
    }

    @NonNull
    private static String capitalize(@Nullable String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    @Nullable
    private static Class<? extends Activity> guessRestartActivityClass(@NonNull Context context) {
        Class<? extends Activity> resolvedActivityClass = CustomActivityOnCrash.getRestartActivityClassWithIntentFilter(context);
        if (resolvedActivityClass == null) {
            resolvedActivityClass = CustomActivityOnCrash.getLauncherActivity(context);
        }
        return resolvedActivityClass;
    }

    @Nullable
    private static Class<? extends Activity> getRestartActivityClassWithIntentFilter(@NonNull Context context) {
        Intent searchedIntent = new Intent().setAction(INTENT_ACTION_RESTART_ACTIVITY).setPackage(context.getPackageName());
        List resolveInfos = context.getPackageManager().queryIntentActivities(searchedIntent, 64);
        if (resolveInfos != null && resolveInfos.size() > 0) {
            ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(0);
            try {
                return Class.forName(resolveInfo.activityInfo.name);
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"Failed when resolving the restart activity class via intent filter, stack trace follows!", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    private static Class<? extends Activity> getLauncherActivity(@NonNull Context context) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (intent != null && intent.getComponent() != null) {
            try {
                return Class.forName(intent.getComponent().getClassName());
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"Failed when resolving the restart activity class via getLaunchIntentForPackage, stack trace follows!", (Throwable)e);
            }
        }
        return null;
    }

    @NonNull
    private static Class<? extends Activity> guessErrorActivityClass(@NonNull Context context) {
        Class<Object> resolvedActivityClass = CustomActivityOnCrash.getErrorActivityClassWithIntentFilter(context);
        if (resolvedActivityClass == null) {
            resolvedActivityClass = DefaultErrorActivity.class;
        }
        return resolvedActivityClass;
    }

    @Nullable
    private static Class<? extends Activity> getErrorActivityClassWithIntentFilter(@NonNull Context context) {
        Intent searchedIntent = new Intent().setAction(INTENT_ACTION_ERROR_ACTIVITY).setPackage(context.getPackageName());
        List resolveInfos = context.getPackageManager().queryIntentActivities(searchedIntent, 64);
        if (resolveInfos != null && resolveInfos.size() > 0) {
            ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(0);
            try {
                return Class.forName(resolveInfo.activityInfo.name);
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"Failed when resolving the error activity class via intent filter, stack trace follows!", (Throwable)e);
            }
        }
        return null;
    }

    private static void killCurrentProcess() {
        Process.killProcess((int)Process.myPid());
        System.exit(10);
    }

    @SuppressLint(value={"ApplySharedPref"})
    private static void setLastCrashTimestamp(@NonNull Context context, long timestamp) {
        context.getSharedPreferences(SHARED_PREFERENCES_FILE, 0).edit().putLong(SHARED_PREFERENCES_FIELD_TIMESTAMP, timestamp).commit();
    }

    private static long getLastCrashTimestamp(@NonNull Context context) {
        return context.getSharedPreferences(SHARED_PREFERENCES_FILE, 0).getLong(SHARED_PREFERENCES_FIELD_TIMESTAMP, -1L);
    }

    private static boolean hasCrashedInTheLastSeconds(@NonNull Context context) {
        long currentTimestamp;
        long lastTimestamp = CustomActivityOnCrash.getLastCrashTimestamp(context);
        return lastTimestamp <= (currentTimestamp = new Date().getTime()) && currentTimestamp - lastTimestamp < (long)config.getMinTimeBetweenCrashesMs();
    }

    static {
        config = new CaocConfig();
        activityLog = new ArrayDeque<String>(50);
        lastActivityCreated = new WeakReference<Object>(null);
        isInBackground = true;
    }

    public static interface EventListener
    extends Serializable {
        public void onLaunchErrorActivity();

        public void onRestartAppFromErrorActivity();

        public void onCloseAppFromErrorActivity();
    }
}

