/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client.taglib;

import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import edu.yale.its.tp.cas.client.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class AuthTag
extends TagSupport {
    private String var;
    private int scope;
    private String casLogin;
    private String casValidate;
    private String service;
    private List acceptedProxies;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public int doStartTag() throws JspException {
        this.request = (HttpServletRequest)this.pageContext.getRequest();
        this.response = (HttpServletResponse)this.pageContext.getResponse();
        this.casLogin = null;
        this.casValidate = null;
        try {
            this.service = Util.getService(this.request, this.pageContext.getServletContext().getInitParameter("edu.yale.its.tp.cas.serverName"));
        }
        catch (ServletException servletException) {
            throw new JspException((Throwable)servletException);
        }
        this.acceptedProxies = new ArrayList();
        return 1;
    }

    public int doEndTag() throws JspTagException {
        try {
            if (this.pageContext.getAttribute(this.var, this.scope) != null) {
                return 6;
            }
            String string = this.request.getParameter("ticket");
            if (string == null || string.equals("")) {
                if (this.casLogin == null) {
                    throw new JspTagException("for pages that expect to be called without 'ticket' parameter, cas:auth must have a cas:loginUrl subtag");
                }
                this.response.sendRedirect(this.casLogin + "?service=" + this.service);
                return 5;
            }
            String string2 = this.getAuthenticatedNetid(string);
            if (string2 == null) {
                throw new JspTagException("Unexpected CAS authentication error");
            }
            this.pageContext.setAttribute(this.var, (Object)string2, this.scope);
            return 6;
        }
        catch (IOException iOException) {
            throw new JspTagException(iOException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new JspTagException(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JspTagException(parserConfigurationException.getMessage());
        }
    }

    public void setVar(String string) {
        this.var = string;
    }

    public void setScope(String string) {
        if (string.equals("page")) {
            this.scope = 1;
        } else if (string.equals("request")) {
            this.scope = 2;
        } else if (string.equals("session")) {
            this.scope = 3;
        } else if (string.equals("application")) {
            this.scope = 4;
        } else {
            throw new IllegalArgumentException("invalid scope");
        }
    }

    public void setCasLogin(String string) {
        this.casLogin = string;
    }

    public void setCasValidate(String string) {
        this.casValidate = string;
    }

    public void addAuthorizedProxy(String string) {
        this.acceptedProxies.add(string);
    }

    public void setService(String string) {
        this.service = string;
    }

    public AuthTag() {
        this.init();
    }

    public void release() {
        super.release();
        this.init();
    }

    private void init() {
        this.var = null;
        this.scope = 1;
        this.casLogin = null;
        this.casValidate = null;
        this.acceptedProxies = null;
    }

    private String getAuthenticatedNetid(String string) throws ParserConfigurationException, SAXException, IOException, JspTagException {
        ProxyTicketValidator proxyTicketValidator = new ProxyTicketValidator();
        proxyTicketValidator.setCasValidateUrl(this.casValidate);
        proxyTicketValidator.setServiceTicket(string);
        proxyTicketValidator.setService(this.service);
        proxyTicketValidator.validate();
        if (!proxyTicketValidator.isAuthenticationSuccesful()) {
            throw new JspTagException("CAS authentication error: " + proxyTicketValidator.getErrorCode());
        }
        if (proxyTicketValidator.getProxyList().size() != 0) {
            if (this.acceptedProxies.size() == 0) {
                throw new JspTagException("this page does not accept proxied tickets");
            }
            if (!this.acceptedProxies.contains(proxyTicketValidator.getProxyList().get(0))) {
                throw new JspTagException("unauthorized top-level proxy: '" + proxyTicketValidator.getProxyList().get(0) + "'");
            }
        }
        return proxyTicketValidator.getUser();
    }
}

