/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.ant;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.CallTarget;

public class StartServerHelper
implements Runnable {
    private URL testURL;
    private String startTarget;
    private Task task;
    private boolean isServerAlreadyStarted = false;

    public boolean isServerAlreadyStarted() {
        return this.isServerAlreadyStarted;
    }

    public StartServerHelper(Task task) {
        this.task = task;
    }

    public void execute() throws BuildException {
        if (this.testURL == null) {
            throw new BuildException("A testURL attribute must be specified");
        }
        if (this.startTarget == null) {
            throw new BuildException("A startTarget Ant target name must be specified");
        }
        if (this.isURLCallable()) {
            this.isServerAlreadyStarted = true;
            this.task.log("Server is already running", 4);
            return;
        }
        this.task.log("Server is not running", 4);
        Thread thread = new Thread(this);
        thread.start();
        this.sleep(1000);
        while (true) {
            this.task.log("Checking if server is up ...", 4);
            if (this.isURLCallable()) break;
            this.sleep(500);
        }
        this.task.log("Server is up !", 4);
        this.sleep(500);
        this.task.log("Server started", 4);
    }

    private void sleep(int n) throws BuildException {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            throw new BuildException("Interruption during sleep", (Throwable)interruptedException);
        }
    }

    private boolean isURLCallable() {
        boolean bl = false;
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.testURL.openConnection();
            httpURLConnection.connect();
            StartServerHelper.readFully(httpURLConnection);
            httpURLConnection.disconnect();
            bl = true;
        }
        catch (IOException iOException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            iOException.printStackTrace(printWriter);
            printWriter.close();
            this.task.log("Failed to call test URL. Reason :" + new String(byteArrayOutputStream.toByteArray()), 4);
        }
        return bl;
    }

    static void readFully(HttpURLConnection httpURLConnection) throws IOException {
        if (httpURLConnection.getContentLength() != 0) {
            byte[] byArray = new byte[256];
            InputStream inputStream = httpURLConnection.getInputStream();
            while (-1 != inputStream.read(byArray)) {
            }
        }
    }

    public void run() {
        CallTarget callTarget = (CallTarget)this.task.getProject().createTask("antcall");
        callTarget.setOwningTarget(this.task.getOwningTarget());
        callTarget.setTaskName(this.task.getTaskName());
        callTarget.setLocation(this.task.getLocation());
        callTarget.setInheritAll(true);
        callTarget.init();
        callTarget.setTarget(this.startTarget);
        callTarget.execute();
    }

    public void setTestURL(String string) {
        try {
            this.testURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException("Bad URL [" + string + "]", (Throwable)malformedURLException);
        }
        this.task.log("Test URL = [" + this.testURL + "]", 4);
    }

    public void setStartTarget(String string) {
        this.startTarget = string;
    }
}

