/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.model;

import ca.vanzyl.provisio.model.ProvisioningRequest;
import ca.vanzyl.provisio.model.ProvisioningResult;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class ProvisioningContext {
    private final ProvisioningRequest request;
    private final ProvisioningResult result;
    private final HashSet<Path> laidDownFiles;

    public ProvisioningContext(ProvisioningRequest request, ProvisioningResult result) {
        this.request = request;
        this.result = result;
        this.laidDownFiles = new HashSet();
    }

    public ProvisioningRequest getRequest() {
        return this.request;
    }

    public ProvisioningResult getResult() {
        return this.result;
    }

    public boolean layDownFile(Path path) {
        Objects.requireNonNull(path);
        return this.laidDownFiles.add(path);
    }

    public boolean deleteLaidDownFile(Path path) {
        Objects.requireNonNull(path);
        return this.laidDownFiles.remove(path);
    }

    public int laidDownFiles() {
        return this.laidDownFiles.size();
    }

    public Map<String, String> getVariables() {
        return this.request.getVariables();
    }
}

