/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.action.artifact;

import ca.vanzyl.provisio.ProvisioUtils;
import ca.vanzyl.provisio.ProvisioVariables;
import ca.vanzyl.provisio.ProvisioningException;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningAction;
import ca.vanzyl.provisio.model.ProvisioningContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.inject.Named;
import org.codehaus.plexus.util.io.CachingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="write")
public class WriteToDiskAction
implements ProvisioningAction {
    private static final Logger logger = LoggerFactory.getLogger(WriteToDiskAction.class);
    private final ProvisioArtifact artifact;
    private final File outputDirectory;

    public WriteToDiskAction(ProvisioArtifact artifact, File outputDirectory) {
        Objects.requireNonNull(outputDirectory, "outputDirectory cannot be null.");
        this.artifact = artifact;
        this.outputDirectory = outputDirectory;
    }

    public void execute(ProvisioningContext context) {
        if (this.artifact.getFile() != null) {
            this.write(context, this.artifact, ProvisioUtils.targetArtifactFileName(context, this.artifact, this.artifact.getFile().getName()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write(ProvisioningContext context, ProvisioArtifact source, String targetPath) {
        File target = new File(this.outputDirectory, targetPath).getAbsoluteFile();
        if (!target.toPath().startsWith(this.outputDirectory.toPath())) {
            throw new IllegalArgumentException("Bad mapping of artifact " + source + "; would escape output directory: " + target);
        }
        try {
            if (!context.layDownFile(target.toPath())) {
                if (!ProvisioVariables.allowTargetOverwrite(context)) throw new ProvisioningException("Conflict: artifact " + this.artifact + " would overwrite existing file: " + targetPath);
                logger.warn("Conflict: artifact {} overwrites existing file {}", (Object)this.artifact, (Object)targetPath);
            }
            Files.createDirectories(target.getParentFile().toPath(), new FileAttribute[0]);
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                CachingOutputStream outputStream = new CachingOutputStream(target.toPath());
                try {
                    try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(this.artifact.getFile()));){
                        inputStream.transferTo((OutputStream)outputStream);
                        outputStream.close();
                        if (outputStream.isModified()) {
                            target.setLastModified(this.artifact.getFile().lastModified());
                        }
                    }
                    if (outputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (outputStream == null) throw throwable;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Error copying " + source + " to " + targetPath, e);
        }
    }
}

